/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public class TestEngineAutoCloseUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineAutoCloseUtils.class);

    private TestEngineAutoCloseUtils() {
    }

    public static void processAutoCloseAnnotatedFields(Object object, String scope) {
        LOGGER.trace("processAutoCloseFields(%s, %s)", object.getClass().getName(), scope);
        TestEngineReflectionUtils.getAutoCloseFields(object.getClass()).forEach(field -> {
            LOGGER.trace("closing field [%s]", (Object)field.getName());
            TestEngine.AutoClose annotation = field.getAnnotation(TestEngine.AutoClose.class);
            String annotationScope = annotation.scope();
            String annotationMethodName = annotation.method();
            if (scope.equals(annotationScope)) {
                TestEngineAutoCloseUtils.close(object, annotationScope, annotationMethodName, field);
            } else {
                LOGGER.trace("skipping field [%s] annotation scope [%s] doesn't match scope [%s]", field.getName(), annotationScope, scope);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void close(Object object, String scope, String methodName, Field field) {
        LOGGER.trace("close(%s, %s, %s)", object.getClass().getName(), methodName, field.getName());
        if (methodName.trim().isEmpty()) {
            try {
                Object o = field.get(object);
                if (!(o instanceof AutoCloseable)) return;
                ((AutoCloseable)o).close();
                return;
            }
            catch (Throwable t) {
                throw new TestEngineException(String.format("Exception closing @TestEngine.AutoClose field [%s] scope [%s]", field.getName(), scope), t);
            }
        }
        try {
            methodName = methodName.trim();
            Object o = field.get(object);
            if (o == null) return;
            Method method = o.getClass().getMethod(methodName, null);
            method.setAccessible(true);
            method.invoke(o, (Object[])null);
            return;
        }
        catch (Throwable t) {
            throw new TestEngineException(String.format("Exception closing @TestEngine.AutoClose field [%s] scope [%s]", field.getName(), scope), t);
        }
    }
}

