/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public class TestEngineLockUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngineLockUtils.class);
    private static final Map<String, ReentrantReadWriteLock> LOCK_MAP = Collections.synchronizedMap(new HashMap());

    private TestEngineLockUtils() {
    }

    public static void processLockAnnotations(Method method) {
        Annotation[] annotations;
        if (!(method.isAnnotationPresent(TestEngine.Lock.class) || method.isAnnotationPresent(TestEngine.Lock.List.class) || method.isAnnotationPresent(TestEngine.ResourceLock.class) || method.isAnnotationPresent(TestEngine.ResourceLock.List.class))) {
            return;
        }
        for (Annotation annotation : annotations = method.getAnnotations()) {
            Annotation lockListAnnotation;
            Annotation lockAnnotation;
            if (annotation.annotationType().isAssignableFrom(TestEngine.Lock.class)) {
                lockAnnotation = (TestEngine.Lock)annotation;
                TestEngineLockUtils.lock(method, lockAnnotation.value(), lockAnnotation.mode());
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.Lock.List.class)) {
                lockListAnnotation = (TestEngine.Lock.List)annotation;
                Stream.of(lockListAnnotation.value()).forEach(lock -> TestEngineLockUtils.lock(method, lock.value(), lock.mode()));
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.class)) {
                lockAnnotation = (TestEngine.ResourceLock)annotation;
                TestEngineLockUtils.lock(method, lockAnnotation.value(), lockAnnotation.mode());
                continue;
            }
            if (!annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.List.class)) continue;
            lockListAnnotation = (TestEngine.ResourceLock.List)annotation;
            Stream.of(lockListAnnotation.value()).forEach(lock -> TestEngineLockUtils.lock(method, lock.value(), lock.mode()));
        }
    }

    private static void lock(Method method, String name, TestEngine.LockMode mode) {
        if (name != null && !name.trim().isEmpty()) {
            name = name.trim();
            LOGGER.trace(String.format("Acquiring lock [%s] mode [%s] class [%s] method [%s]", new Object[]{name, mode, method.getDeclaringClass().getName(), method.getName()}));
            if (mode == TestEngine.LockMode.READ_WRITE) {
                LOCK_MAP.computeIfAbsent(name, n -> new ReentrantReadWriteLock(true)).writeLock().lock();
            } else {
                LOCK_MAP.computeIfAbsent(name, n -> new ReentrantReadWriteLock(true)).readLock().lock();
            }
            LOGGER.trace(String.format("Acquired lock [%s] mode [%s] class [%s] method [%s]", new Object[]{name, mode, method.getDeclaringClass().getName(), method.getName()}));
        }
    }

    public static void processUnlockAnnotations(Method method) {
        Annotation[] annotations;
        if (!(method.isAnnotationPresent(TestEngine.Unlock.class) || method.isAnnotationPresent(TestEngine.Unlock.List.class) || method.isAnnotationPresent(TestEngine.ResourceLock.class) || method.isAnnotationPresent(TestEngine.ResourceLock.List.class))) {
            return;
        }
        for (Annotation annotation : annotations = method.getAnnotations()) {
            Annotation unlockListAnnotation;
            Annotation unlockAnnotation;
            if (annotation.annotationType().isAssignableFrom(TestEngine.Unlock.class)) {
                unlockAnnotation = (TestEngine.Unlock)annotation;
                TestEngineLockUtils.unlock(method, unlockAnnotation.value(), unlockAnnotation.mode());
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.Unlock.List.class)) {
                unlockListAnnotation = (TestEngine.Unlock.List)annotation;
                Stream.of(unlockListAnnotation.value()).forEach(lock -> TestEngineLockUtils.unlock(method, lock.value(), lock.mode()));
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.class)) {
                unlockAnnotation = (TestEngine.ResourceLock)annotation;
                TestEngineLockUtils.unlock(method, unlockAnnotation.value(), unlockAnnotation.mode());
                continue;
            }
            if (!annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.List.class)) continue;
            unlockListAnnotation = (TestEngine.ResourceLock.List)annotation;
            List<TestEngine.ResourceLock> list = Arrays.asList(unlockListAnnotation.value());
            Collections.reverse(list);
            list.stream().forEach(lock -> TestEngineLockUtils.unlock(method, lock.value(), lock.mode()));
        }
    }

    private static void unlock(Method method, String name, TestEngine.LockMode mode) {
        if (name != null && !name.trim().isEmpty()) {
            ReentrantReadWriteLock reentrantReadWriteLock = LOCK_MAP.get(name = name.trim());
            if (reentrantReadWriteLock != null) {
                LOGGER.trace(String.format("Releasing lock [%s] mode [%s] class [%s] method [%s]", new Object[]{name, mode, method.getDeclaringClass().getName(), method.getName()}));
                if (mode == TestEngine.LockMode.READ_WRITE) {
                    reentrantReadWriteLock.writeLock().unlock();
                } else {
                    reentrantReadWriteLock.readLock().unlock();
                }
                LOGGER.trace(String.format("Released lock [%s] mode [%s] class [%s] method [%s]", new Object[]{name, mode, method.getDeclaringClass().getName(), method.getName()}));
            } else {
                throw new TestClassConfigurationException(String.format("@TestEngine.Unlock without @TestEngine.Lock, name [%s] mode [%s] class [%s] method [%s]", new Object[]{name, mode, method.getDeclaringClass().getName(), method.getName()}));
            }
        }
    }
}

