/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.antublue.test.engine.api.StoreException;

public class Store {
    private static final Lock LOCK = new ReentrantLock(true);
    private static final Map<String, Object> MAP = new LinkedHashMap<String, Object>();

    private Store() {
    }

    public static Lock lock() {
        LOCK.lock();
        return LOCK;
    }

    public static Lock unlock() {
        LOCK.unlock();
        return LOCK;
    }

    public static Lock getLock() {
        return LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Object> put(String key, Object object) {
        String validKey = Store.validateKey(key);
        try {
            Store.lock();
            Optional<Object> optional = Optional.ofNullable(MAP.put(validKey, object));
            return optional;
        }
        finally {
            Store.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Object> putIfAbsent(String key, Function<String, Object> function) {
        String validKey = Store.validateKey(key);
        Store.validateObject(function, "function is null");
        try {
            Store.lock();
            Optional<Object> optional = Optional.ofNullable(MAP.computeIfAbsent(validKey, function));
            return optional;
        }
        finally {
            Store.unlock();
        }
    }

    public static Optional<Object> get(String key) {
        String validKey = Store.validateKey(key);
        try {
            Store.lock();
            Optional<Object> optional = Optional.ofNullable(MAP.get(validKey));
            return optional;
        }
        finally {
            Store.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Optional<T> get(String key, Class<T> clazz) {
        String validKey = Store.validateKey(key);
        Store.validateObject(clazz, "class is null");
        try {
            Store.lock();
            Optional<T> optional = Optional.ofNullable(clazz.cast(MAP.get(validKey)));
            return optional;
        }
        finally {
            Store.unlock();
        }
    }

    public static Optional<Object> remove(String key) {
        try {
            Store.lock();
            Optional<Object> optional = Optional.ofNullable(MAP.remove(key));
            return optional;
        }
        finally {
            Store.unlock();
        }
    }

    public static <T> Optional<T> remove(String key, Class<T> clazz) {
        try {
            Store.lock();
            Optional<T> optional = Optional.ofNullable(clazz.cast(MAP.remove(key)));
            return optional;
        }
        finally {
            Store.unlock();
        }
    }

    public static void removeAndClose(String key) throws StoreException {
        Store.remove(key).ifPresent(o -> {
            if (o instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)o).close();
                }
                catch (Throwable t) {
                    throw new StoreException(String.format("Exception closing Object for key [%s] object [%s]", key, o.getClass().getName()), t);
                }
            }
        });
    }

    private static String validateKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (key.trim().isEmpty()) {
            throw new IllegalArgumentException("key is empty");
        }
        return key.trim();
    }

    private static void validateObject(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }
}

