/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import java.math.BigInteger;
import java.util.Objects;
import org.antublue.test.engine.api.argument.AbstractArgument;

public class BigIntegerArgument
extends AbstractArgument {
    private final String name;
    private final BigInteger value;

    public BigIntegerArgument(String name, BigInteger value) {
        this.name = this.validateName(name);
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public BigInteger value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BigIntegerArgument that = (BigIntegerArgument)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static BigIntegerArgument of(BigInteger value) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        return new BigIntegerArgument(String.valueOf(value).toUpperCase(), value);
    }
}

