/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import java.util.Objects;
import org.antublue.test.engine.api.argument.AbstractArgument;

public class BooleanArgument
extends AbstractArgument {
    private final String name;
    private final boolean value;

    public BooleanArgument(String name, boolean value) {
        this.name = this.validateName(name);
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public boolean value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanArgument that = (BooleanArgument)o;
        return this.value == that.value && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static BooleanArgument of(boolean value) {
        return new BooleanArgument(String.valueOf(value).toUpperCase(), value);
    }
}

