/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import java.util.Objects;
import org.antublue.test.engine.api.argument.AbstractArgument;

public class CharArgument
extends AbstractArgument {
    private final String name;
    private final char value;

    public CharArgument(String name, char value) {
        this.name = this.validateName(name);
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public char value() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharArgument that = (CharArgument)o;
        return this.value == that.value && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, Character.valueOf(this.value));
    }

    public static CharArgument of(char value) {
        return new CharArgument(String.valueOf(value).toUpperCase(), value);
    }
}

