/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.api.argument;

import java.util.Objects;
import org.antublue.test.engine.api.argument.AbstractArgument;

public class ShortArgument
extends AbstractArgument {
    private final String name;
    private final short value;

    public ShortArgument(String name, short value) {
        this.name = this.validateName(name);
        this.value = value;
    }

    @Override
    public String name() {
        return this.name;
    }

    public short value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortArgument that = (ShortArgument)o;
        return this.value == that.value && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static ShortArgument of(short value) {
        return new ShortArgument(String.valueOf(value).toUpperCase(), value);
    }
}

