/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.TestEngineAutoCloseUtils;
import org.antublue.test.engine.internal.TestEngineExecutorContext;
import org.antublue.test.engine.internal.TestEngineLockUtils;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.FieldUtils;
import org.antublue.test.engine.internal.util.MethodUtils;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class ArgumentTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument testArgument;

    ArgumentTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)TestEngineReflectionUtils.getArgumentSupplierMethod(this.testClass)));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    @Override
    public void execute(TestEngineExecutorContext testEngineExecutorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        EngineExecutionListener engineExecutionListener = testEngineExecutorContext.getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        ThrowableCollector throwableCollector = testEngineExecutorContext.getThrowableCollector();
        Field field = TestEngineReflectionUtils.getArgumentField(this.testClass);
        FieldUtils.setField(this.testInstance, field, this.testArgument, throwable -> {
            throwableCollector.add((Throwable)throwable);
            throwable.printStackTrace();
        });
        if (throwableCollector.isEmpty()) {
            List<Method> methods = TestEngineReflectionUtils.getBeforeAllMethods(this.testClass);
            for (Method method : methods) {
                LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
                TestEngineLockUtils.processLockAnnotations(method);
                MethodUtils.invoke(this.testInstance, method, throwable -> {
                    throwableCollector.add((Throwable)throwable);
                    throwable.printStackTrace();
                });
                TestEngineLockUtils.processUnlockAnnotations(method);
                if (!throwableCollector.isNotEmpty()) continue;
                break;
            }
        }
        List methodTestDescriptors = this.getChildren(MethodTestDescriptor.class);
        if (throwableCollector.isEmpty()) {
            methodTestDescriptors.forEach(methodTestDescriptor -> {
                methodTestDescriptor.setTestInstance(this.testInstance);
                methodTestDescriptor.execute(testEngineExecutorContext);
            });
        } else {
            methodTestDescriptors.forEach(methodTestDescriptor -> {
                LOGGER.trace("skip uniqueId [%s] testClass [%s] testMethod [%s]", methodTestDescriptor.getUniqueId(), this.testClass.getName(), methodTestDescriptor.getTestMethod().getName());
                methodTestDescriptor.skip(testEngineExecutorContext);
            });
        }
        List<Method> methods = TestEngineReflectionUtils.getAfterAllMethods(this.testClass);
        for (Method method : methods) {
            LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
            TestEngineLockUtils.processLockAnnotations(method);
            MethodUtils.invoke(this.testInstance, method, throwable -> {
                throwableCollector.add((Throwable)throwable);
                throwable.printStackTrace();
            });
            TestEngineLockUtils.processUnlockAnnotations(method);
        }
        TestEngineAutoCloseUtils.processAutoCloseAnnotatedFields(this.testInstance, "@TestEngine.AfterAll", throwable -> {
            throwableCollector.add((Throwable)throwable);
            throwable.printStackTrace();
        });
        FieldUtils.setField(this.testInstance, field, null, throwable -> {});
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
    }
}

