/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.internal.TestEngineAutoCloseUtils;
import org.antublue.test.engine.internal.TestEngineExecutorContext;
import org.antublue.test.engine.internal.TestEngineLockUtils;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.MethodUtils;
import org.antublue.test.engine.internal.util.ObjectUtils;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public final class ClassTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassTestDescriptor.class);
    private final Class<?> testClass;

    ClassTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass) {
        super(uniqueId, displayName);
        this.testClass = testClass;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public void execute(TestEngineExecutorContext testEngineExecutorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        EngineExecutionListener engineExecutionListener = testEngineExecutorContext.getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        ThrowableCollector throwableCollector = testEngineExecutorContext.getThrowableCollector();
        ObjectUtils.instantiate(this.testClass, o -> {
            this.testInstance = o;
        }, throwableCollector::add);
        if (throwableCollector.isEmpty()) {
            List<Method> methods = TestEngineReflectionUtils.getPrepareMethods(this.testClass);
            for (Method method : methods) {
                LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
                TestEngineLockUtils.processLockAnnotations(method);
                MethodUtils.invoke(this.testInstance, method, throwable -> {
                    throwableCollector.add((Throwable)throwable);
                    throwable.printStackTrace();
                });
                TestEngineLockUtils.processUnlockAnnotations(method);
                if (!throwableCollector.isNotEmpty()) continue;
                break;
            }
        }
        List argumentTestDescriptors = this.getChildren(ArgumentTestDescriptor.class);
        if (throwableCollector.isEmpty()) {
            argumentTestDescriptors.forEach(argumentTestDescriptor -> {
                argumentTestDescriptor.setTestInstance(this.testInstance);
                argumentTestDescriptor.execute(testEngineExecutorContext);
            });
        } else {
            argumentTestDescriptors.forEach(argumentTestDescriptor -> {
                LOGGER.trace("skip uniqueId [%s] testClass [%s] testArgument [%s]", argumentTestDescriptor.getUniqueId(), this.testClass.getName(), argumentTestDescriptor.getTestArgument().name());
                argumentTestDescriptor.skip(testEngineExecutorContext);
            });
        }
        if (this.testInstance != null) {
            List<Method> methods = TestEngineReflectionUtils.getConcludeMethods(this.testClass);
            for (Method method : methods) {
                LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
                TestEngineLockUtils.processLockAnnotations(method);
                MethodUtils.invoke(this.testInstance, method, throwable -> {
                    throwableCollector.add((Throwable)throwable);
                    throwable.printStackTrace();
                });
                TestEngineLockUtils.processUnlockAnnotations(method);
            }
            TestEngineAutoCloseUtils.processAutoCloseAnnotatedFields(this.testInstance, "@TestEngine.Conclude", throwable -> {
                throwableCollector.add((Throwable)throwable);
                throwable.printStackTrace();
            });
        }
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
        this.testInstance = null;
        testEngineExecutorContext.complete();
    }
}

