/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.TestEngineAutoCloseUtils;
import org.antublue.test.engine.internal.TestEngineExecutorContext;
import org.antublue.test.engine.internal.TestEngineLockUtils;
import org.antublue.test.engine.internal.TestEngineReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.MethodUtils;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class MethodTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument testArgument;
    private final Method testMethod;

    MethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument testArgument, Method testMethod) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
        this.testMethod = testMethod;
        testMethod.setAccessible(true);
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public boolean isTest() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    @Override
    public void execute(TestEngineExecutorContext testEngineExecutorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s] testArgument [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name(), this.testMethod.getName());
        EngineExecutionListener engineExecutionListener = testEngineExecutorContext.getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        ThrowableCollector throwableCollector = testEngineExecutorContext.getThrowableCollector();
        List<Method> methods = TestEngineReflectionUtils.getBeforeEachMethods(this.testClass);
        for (Method method : methods) {
            LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
            TestEngineLockUtils.processLockAnnotations(method);
            MethodUtils.invoke(this.testInstance, method, throwable -> {
                throwableCollector.add((Throwable)throwable);
                throwable.printStackTrace();
            });
            TestEngineLockUtils.processUnlockAnnotations(method);
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
        if (throwableCollector.isEmpty()) {
            LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName());
            TestEngineLockUtils.processLockAnnotations(this.testMethod);
            MethodUtils.invoke(this.testInstance, this.testMethod, throwable -> {
                throwableCollector.add((Throwable)throwable);
                throwable.printStackTrace();
            });
            TestEngineLockUtils.processUnlockAnnotations(this.testMethod);
        }
        methods = TestEngineReflectionUtils.getAfterEachMethods(this.testClass);
        for (Method method : methods) {
            LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
            TestEngineLockUtils.processLockAnnotations(method);
            MethodUtils.invoke(this.testInstance, method, throwable -> {
                throwableCollector.add((Throwable)throwable);
                throwable.printStackTrace();
            });
            TestEngineLockUtils.processUnlockAnnotations(method);
        }
        TestEngineAutoCloseUtils.processAutoCloseAnnotatedFields(this.testInstance, "@TestEngine.AfterEach", throwable -> {
            throwableCollector.add((Throwable)throwable);
            throwable.printStackTrace();
        });
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
    }
}

