/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.antublue.test.engine.internal.util.Precondition;

public class MethodUtils {
    private MethodUtils() {
    }

    public static void invoke(Object object, Method method, Consumer<Throwable> throwableConsumer) {
        Precondition.notNull(object, "object is null");
        Precondition.notNull(method, "method is null");
        Precondition.notNull(throwableConsumer, "throwableConsumer is null");
        MethodUtils.invoke(object, method, null, throwableConsumer);
    }

    public static void invoke(Object object, Method method, Object[] arguments, Consumer<Throwable> throwableConsumer) {
        Precondition.notNull(object, "object is null");
        Precondition.notNull(method, "method is null");
        Precondition.notNull(throwableConsumer, "throwableConsumer is null");
        try {
            method.invoke(object, arguments);
        }
        catch (Throwable t) {
            throwableConsumer.accept(t.getCause());
        }
    }
}

