/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine;

import java.util.Optional;
import org.antublue.test.engine.internal.ConfigurationParameters;
import org.antublue.test.engine.internal.Executor;
import org.antublue.test.engine.internal.Information;
import org.antublue.test.engine.internal.Resolver;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.TestDescriptorStore;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.descriptor.ExtendedEngineDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

public class TestEngine
implements org.junit.platform.engine.TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngine.class);
    public static final String ENGINE_ID = "antublue-test-engine";
    public static final String GROUP_ID = "org.antublue";
    public static final String ARTIFACT_ID = "test-engine";
    public static final String VERSION = Information.getVersion();
    public static final String ANTUBLUE_TEST_ENGINE_MAVEN_PLUGIN = "__ANTUBLUE_TEST_ENGINE_MAVEN_PLUGIN__";
    public static final String ANTUBLUE_TEST_ENGINE_MAVEN_BATCH_MODE = "__ANTUBLUE_TEST_ENGINE_MAVEN_BATCH_MODE__";

    public String getId() {
        return ENGINE_ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of(GROUP_ID);
    }

    public Optional<String> getArtifactId() {
        return Optional.of(ARTIFACT_ID);
    }

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        LOGGER.trace("discover()");
        try {
            ConfigurationParameters configurationParameters = new ConfigurationParameters();
            ExtendedEngineDescriptor engineDescriptor = new ExtendedEngineDescriptor(UniqueId.forEngine((String)this.getId()), this.getId());
            new Resolver().resolve(engineDiscoveryRequest, configurationParameters, engineDescriptor);
            TestDescriptorStore.getInstance().store(engineDescriptor);
            return engineDescriptor;
        }
        catch (TestClassConfigurationException | TestEngineException t) {
            if ("true".equals(System.getProperty(ANTUBLUE_TEST_ENGINE_MAVEN_PLUGIN))) {
                throw t;
            }
            System.err.println(t.getMessage());
            System.exit(1);
        }
        catch (Throwable t) {
            throw new TestEngineException("General exception", t);
        }
        return null;
    }

    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute()");
        new Executor().execute(executionRequest);
    }
}

