/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ConfigurationParameters
implements org.junit.platform.engine.ConfigurationParameters {
    public Optional<String> get(String key) {
        return Optional.ofNullable(this.resolve(key));
    }

    public Optional<Boolean> getBoolean(String key) {
        return Optional.of(Boolean.parseBoolean(this.resolve(key)));
    }

    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        String value = this.resolve(key);
        T t = transformer.apply(value);
        return Optional.ofNullable(t);
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    private String resolve(String key) {
        String value = System.getenv(key.toUpperCase(Locale.ENGLISH).replace('.', '_'));
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        value = System.getProperty(key);
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        return null;
    }
}

