/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Precondition;
import org.junit.platform.commons.support.ReflectionSupport;

public final class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Map<Class<?>, Method> ARGUMENT_SUPPLIER_METHOD_CACHE = new HashMap();
    private static final Map<Class<?>, Field> ARGUMENT_FIELD_CACHE = new HashMap();
    private static final Map<Class<?>, List<Field>> AUTO_CLOSE_FIELD_CACHE = new HashMap();
    private static final Map<Class<?>, List<Method>> PREPARE_METHOD_CACHE = new HashMap();
    private static final Map<Class<?>, List<Method>> BEFORE_ALL_METHOD_CACHE = new HashMap();
    private static final Map<Class<?>, List<Method>> BEFORE_EACH_METHOD_CACHE = new HashMap();
    private static final Map<Class<?>, List<Method>> TEST_METHOD_CACHE = new HashMap();
    private static final Map<Class<?>, List<Method>> AFTER_EACH_METHOD_CACHE = new HashMap();
    private static final Map<Class<?>, List<Method>> AFTER_ALL_METHOD_CACHE = new HashMap();
    private static final Map<Class<?>, List<Method>> CONCLUDE_METHOD_CACHE = new HashMap();

    private ReflectionUtils() {
    }

    public static List<Class<?>> findAllClasses(URI uri) {
        ArrayList classes = org.junit.platform.commons.util.ReflectionUtils.findAllClassesInClasspathRoot((URI)uri, classFilter -> true, classNameFilter -> true);
        classes = new ArrayList(classes);
        ReflectionUtils.sortClasses(classes);
        ReflectionUtils.validateDistinctOrder(classes);
        return classes;
    }

    public static List<Class<?>> findAllClasses(String packageName) {
        ArrayList classes = ReflectionSupport.findAllClassesInPackage((String)packageName, classFilter -> true, classNameFilter -> true);
        classes = new ArrayList(classes);
        ReflectionUtils.sortClasses(classes);
        ReflectionUtils.validateDistinctOrder(classes);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getArgumentSupplierMethod(Class<?> clazz) {
        Map<Class<?>, Method> map = ARGUMENT_SUPPLIER_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getArgumentSupplierMethod(%s)", (Object)clazz.getName());
            if (ARGUMENT_SUPPLIER_METHOD_CACHE.containsKey(clazz)) {
                return ARGUMENT_SUPPLIER_METHOD_CACHE.get(clazz);
            }
            List<Method> methodList = ReflectionUtils.getMethods(clazz, TestEngine.ArgumentSupplier.class, Scope.STATIC, Stream.class, null);
            if (methodList.size() == 0) {
                methodList = ReflectionUtils.getMethods(clazz, TestEngine.ArgumentSupplier.class, Scope.STATIC, Iterable.class, null);
            }
            LOGGER.trace("class [%s] @TestEngine.ArgumentSupplier method count [%d]", clazz.getName(), methodList.size());
            if (methodList.size() != 1) {
                throw new TestClassConfigurationException(String.format("Test class [%s] must define one @TestEngine.ArgumentSupplier method", clazz.getName()));
            }
            Method method = methodList.get(0);
            ARGUMENT_SUPPLIER_METHOD_CACHE.put(clazz, method);
            return method;
        }
    }

    public static List<Argument> getArgumentsList(Class<?> clazz) {
        LOGGER.trace("getArgumentsList(%s)", (Object)clazz.getName());
        try {
            Method method = ReflectionUtils.getArgumentSupplierMethod(clazz);
            Object object = method.invoke(null, (Object[])null);
            if (object instanceof Stream) {
                List<Argument> arguments = ((Stream)object).collect(Collectors.toList());
                LOGGER.trace("class [%s] argument count [%d]", clazz.getName(), arguments.size());
                return arguments;
            }
            if (object instanceof Iterable) {
                ArrayList<Argument> arguments = new ArrayList<Argument>();
                ((Iterable)object).forEach(arguments::add);
                LOGGER.trace("class [%s] argument count [%d]", clazz.getName(), arguments.size());
                return arguments;
            }
            throw new TestClassConfigurationException(String.format("Test class [%s] must define one @TestEngine.ArgumentSupplier method", clazz.getName()));
        }
        catch (TestClassConfigurationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestClassConfigurationException(String.format("Can't get Stream<Argument> or Iterable<Argument> from test class [%s]", clazz.getName()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getPrepareMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = PREPARE_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getPrepareMethods(%s)", (Object)clazz.getName());
            if (PREPARE_METHOD_CACHE.containsKey(clazz)) {
                return PREPARE_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = ReflectionUtils.getMethods(clazz, TestEngine.Prepare.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.Prepare method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                ReflectionUtils.sortMethods(methods);
                ReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            PREPARE_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field getArgumentField(Class<?> clazz) {
        Map<Class<?>, Field> map = ARGUMENT_FIELD_CACHE;
        synchronized (map) {
            LOGGER.trace("getArgumentField(%s)", (Object)clazz.getName());
            if (ARGUMENT_FIELD_CACHE.containsKey(clazz)) {
                return ARGUMENT_FIELD_CACHE.get(clazz);
            }
            List<Field> argumentFields = ReflectionUtils.getFields(clazz, TestEngine.Argument.class, Argument.class);
            LOGGER.trace("class [%s] @TestEngine.Argument field count [%d]", clazz.getName(), argumentFields.size());
            if (argumentFields.size() != 1) {
                throw new TestClassConfigurationException(String.format("Test class [%s] must define one @TestEngine.Argument field", clazz.getName()));
            }
            ARGUMENT_FIELD_CACHE.put(clazz, argumentFields.get(0));
            return argumentFields.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getAutoCloseFields(Class<?> clazz) {
        Map<Class<?>, List<Field>> map = AUTO_CLOSE_FIELD_CACHE;
        synchronized (map) {
            LOGGER.trace("getAutoCloseFields(%s)", (Object)clazz.getName());
            if (AUTO_CLOSE_FIELD_CACHE.containsKey(clazz)) {
                return AUTO_CLOSE_FIELD_CACHE.get(clazz);
            }
            List<Field> autoCloseFields = ReflectionUtils.getFields(clazz, TestEngine.AutoClose.class, Object.class);
            LOGGER.trace("class [%s] @TestEngine.AutoClose field count [%d]", clazz.getName(), autoCloseFields.size());
            AUTO_CLOSE_FIELD_CACHE.put(clazz, autoCloseFields);
            return autoCloseFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getBeforeAllMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = BEFORE_ALL_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getBeforeAllMethods(%s)", (Object)clazz.getName());
            if (BEFORE_ALL_METHOD_CACHE.containsKey(clazz)) {
                return BEFORE_ALL_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = ReflectionUtils.getMethods(clazz, TestEngine.BeforeAll.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.BeforeAll method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                ReflectionUtils.sortMethods(methods);
                ReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            BEFORE_ALL_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getBeforeEachMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = BEFORE_EACH_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getBeforeEachMethods(%s)", (Object)clazz.getName());
            if (BEFORE_EACH_METHOD_CACHE.containsKey(clazz)) {
                return BEFORE_EACH_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = ReflectionUtils.getMethods(clazz, TestEngine.BeforeEach.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.BeforeEach method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                ReflectionUtils.sortMethods(methods);
                ReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            BEFORE_EACH_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getTestMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = TEST_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getTestMethods(%s)", (Object)clazz.getName());
            if (TEST_METHOD_CACHE.containsKey(clazz)) {
                return new ArrayList<Method>((Collection)TEST_METHOD_CACHE.get(clazz));
            }
            List<Method> methods = ReflectionUtils.getMethods(clazz, TestEngine.Test.class, Scope.NON_STATIC, Void.class, null).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList());
            LOGGER.trace("class [%s] @TestEngine.Test method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                ReflectionUtils.sortMethods(methods);
                ReflectionUtils.validateDistinctOrder(clazz, methods);
                methods = Collections.unmodifiableList(methods);
            }
            TEST_METHOD_CACHE.put(clazz, methods);
            return new ArrayList<Method>(methods);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getAfterEachMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = AFTER_EACH_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getAfterEachMethods(%s)", (Object)clazz.getName());
            if (AFTER_EACH_METHOD_CACHE.containsKey(clazz)) {
                return AFTER_EACH_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = ReflectionUtils.getMethods(clazz, TestEngine.AfterEach.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.AfterEach method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                ReflectionUtils.sortMethods(methods);
                ReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            AFTER_EACH_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getAfterAllMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = AFTER_ALL_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getAfterAllMethods(%s)", (Object)clazz.getName());
            if (AFTER_ALL_METHOD_CACHE.containsKey(clazz)) {
                return AFTER_ALL_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = ReflectionUtils.getMethods(clazz, TestEngine.AfterAll.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.AfterAll method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                ReflectionUtils.sortMethods(methods);
                ReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            AFTER_ALL_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> getConcludeMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = CONCLUDE_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getConcludeMethods(%s)", (Object)clazz.getName());
            if (CONCLUDE_METHOD_CACHE.containsKey(clazz)) {
                return CONCLUDE_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = ReflectionUtils.getMethods(clazz, TestEngine.Conclude.class, Scope.NON_STATIC, Void.class, null);
            LOGGER.trace("class [%s] @TestEngine.Conclude method count [%d]", clazz.getName(), methods.size());
            if (!methods.isEmpty()) {
                ReflectionUtils.sortMethods(methods);
                ReflectionUtils.validateDistinctOrder(clazz, methods);
            }
            methods = Collections.unmodifiableList(methods);
            CONCLUDE_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    public static String getDisplayName(Method method) {
        String name;
        String displayName = method.getName();
        TestEngine.DisplayName annotation = method.getAnnotation(TestEngine.DisplayName.class);
        if (annotation != null && (name = annotation.name()) != null && !name.trim().isEmpty()) {
            displayName = name.trim();
        }
        LOGGER.trace("method [%s] display name [%s]", method.getName(), displayName);
        return displayName;
    }

    public static String getDisplayName(Class<?> clazz) {
        String name;
        String displayName = clazz.getName();
        TestEngine.DisplayName annotation = clazz.getAnnotation(TestEngine.DisplayName.class);
        if (annotation != null && (name = annotation.name()) != null && !name.trim().isEmpty()) {
            displayName = name.trim();
        }
        LOGGER.trace("class [%s] display name [%s]", clazz.getName(), displayName);
        return displayName;
    }

    public static void instantiate(Class<?> clazz, Consumer<Object> objectConsumer, Consumer<Throwable> throwableConsumer) {
        Precondition.notNull(clazz, "clazz is null");
        Precondition.notNull(objectConsumer, "objectConsumer is null");
        Precondition.notNull(throwableConsumer, "throwableConsumer is null");
        try {
            Object object = clazz.getDeclaredConstructor(null).newInstance(null);
            objectConsumer.accept(object);
        }
        catch (Throwable t) {
            throwableConsumer.accept(t.getCause());
        }
    }

    public static void setField(Object object, Field field, Object value, Consumer<Throwable> throwableConsumer) {
        Precondition.notNull(object, "object is null");
        Precondition.notNull(field, "field is null");
        Precondition.notNull(throwableConsumer, "throwableConsumer is null");
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throwableConsumer.accept(t);
        }
    }

    public static void invoke(Object object, Method method, Consumer<Throwable> throwableConsumer) {
        Precondition.notNull(object, "object is null");
        Precondition.notNull(method, "method is null");
        Precondition.notNull(throwableConsumer, "throwableConsumer is null");
        ReflectionUtils.invoke(object, method, null, throwableConsumer);
    }

    public static void invoke(Object object, Method method, Object[] arguments, Consumer<Throwable> throwableConsumer) {
        Precondition.notNull(object, "object is null");
        Precondition.notNull(method, "method is null");
        Precondition.notNull(throwableConsumer, "throwableConsumer is null");
        try {
            method.invoke(object, arguments);
        }
        catch (Throwable t) {
            throwableConsumer.accept(t.getCause());
        }
    }

    private static List<Field> getFields(Class<?> clazz, Class<? extends Annotation> annotation, Class<?> fieldType) {
        LOGGER.trace("getFields(%s, %s, %s)", clazz.getName(), annotation.getName(), fieldType.getName());
        LinkedHashSet<Field> fieldSet = new LinkedHashSet<Field>();
        ReflectionUtils.resolveFields(clazz, annotation, fieldType, fieldSet);
        ArrayList<Field> fields = new ArrayList<Field>(fieldSet);
        fields.sort(Comparator.comparing(Field::getName));
        LOGGER.trace("class [%s] argument field count [%d]", clazz.getName(), fieldSet.size());
        return fields;
    }

    private static void resolveFields(Class<?> clazz, Class<? extends Annotation> annotation, Class<?> fieldType, Set<Field> fieldSet) {
        LOGGER.trace("resolveFields(%s, %s, %s)", clazz.getName(), annotation.getName(), fieldType.getName());
        Stream.of(clazz.getDeclaredFields()).filter(field -> {
            int modifiers = field.getModifiers();
            return !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && field.isAnnotationPresent(annotation) && fieldType.isAssignableFrom(field.getType());
        }).forEach(field -> {
            field.setAccessible(true);
            fieldSet.add((Field)field);
        });
        Class<?> declaringClass = clazz.getSuperclass();
        if (declaringClass != null && !declaringClass.equals(Object.class)) {
            ReflectionUtils.resolveFields(declaringClass, annotation, fieldType, fieldSet);
        }
    }

    private static List<Method> getMethods(Class<?> clazz, Class<? extends Annotation> annotation, Scope scope, Class<?> returnType, Class<?> ... parameterTypes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("getMethods(%s, %s, %s, %s", new Object[]{clazz.getName(), annotation.getName(), scope, returnType.getName()}));
        if (parameterTypes != null) {
            for (Class<?> parameterTypeClass : parameterTypes) {
                stringBuilder.append(", ").append(parameterTypeClass.getName());
            }
        }
        stringBuilder.append(")");
        LOGGER.trace(stringBuilder.toString());
        HashMap<String, Method> methodMap = new HashMap<String, Method>();
        ReflectionUtils.resolveMethods(clazz, annotation, scope, returnType, parameterTypes, methodMap);
        ArrayList<Method> methodList = new ArrayList<Method>(methodMap.values());
        methodList.sort(Comparator.comparing(Method::getName));
        return methodList;
    }

    private static void resolveMethods(Class<?> clazz, Class<? extends Annotation> annotation, Scope scope, Class<?> returnType, Class<?>[] parameterTypes, Map<String, Method> methodMap) {
        if (LOGGER.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("resolveMethods(%s, %s, %s, %s", new Object[]{clazz.getName(), annotation.getName(), scope, returnType.getName()}));
            if (parameterTypes != null) {
                for (Class<?> parameterTypeClass : parameterTypes) {
                    stringBuilder.append(", ").append(parameterTypeClass.getName());
                }
            }
            stringBuilder.append(")");
            LOGGER.trace(stringBuilder.toString());
        }
        try {
            Stream.of(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(annotation)).filter(method -> {
                int modifiers = method.getModifiers();
                return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
            }).filter(method -> {
                int modifiers = method.getModifiers();
                if (scope == Scope.STATIC && !Modifier.isStatic(modifiers)) {
                    throw new TestClassConfigurationException(String.format("%s method [%s] must be declared static", ReflectionUtils.getAnnotationDisplayName(annotation), method.getName()));
                }
                if (scope != Scope.STATIC && Modifier.isStatic(modifiers)) {
                    throw new TestClassConfigurationException(String.format("%s method [%s] must be not be declared static", ReflectionUtils.getAnnotationDisplayName(annotation), method.getName()));
                }
                return true;
            }).filter(method -> {
                if (parameterTypes == null) {
                    return method.getParameterTypes().length == 0;
                }
                if (parameterTypes.length != method.getParameterCount()) {
                    return false;
                }
                Class<?>[] methodParameterTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i].isAssignableFrom(methodParameterTypes[i])) continue;
                    return false;
                }
                return true;
            }).filter(method -> {
                if (returnType == Void.class) {
                    return method.getReturnType().getName().equals("void");
                }
                return returnType.isAssignableFrom(method.getReturnType());
            }).forEach(method -> {
                if (methodMap.putIfAbsent(method.getName(), (Method)method) == null) {
                    method.setAccessible(true);
                }
            });
        }
        catch (NoClassDefFoundError stringBuilder) {
        }
        catch (TestEngineException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestEngineException(String.format("Exception resolving methods class [%s]", clazz.getName()), t);
        }
        Class<?> declaringClass = clazz.getSuperclass();
        if (declaringClass != null && !declaringClass.equals(Object.class)) {
            ReflectionUtils.resolveMethods(declaringClass, annotation, scope, returnType, parameterTypes, methodMap);
        }
    }

    public static void sortClasses(List<Class<?>> classes) {
        classes.sort((o1, o2) -> {
            boolean o1AnnotationPresent = o1.isAnnotationPresent(TestEngine.Order.class);
            boolean o2AnnotationPresent = o2.isAnnotationPresent(TestEngine.Order.class);
            if (o1AnnotationPresent) {
                if (o2AnnotationPresent) {
                    int o1Order = o1.getAnnotation(TestEngine.Order.class).order();
                    int o2Order = o2.getAnnotation(TestEngine.Order.class).order();
                    return Integer.compare(o1Order, o2Order);
                }
                return -1;
            }
            if (o2AnnotationPresent) {
                return 1;
            }
            String o1DisplayName = ReflectionUtils.getDisplayName(o1);
            String o2DisplayName = ReflectionUtils.getDisplayName(o2);
            return o1DisplayName.compareTo(o2DisplayName);
        });
    }

    private static void validateDistinctOrder(List<Class<?>> classes) {
        LinkedHashMap orderToClassMap = new LinkedHashMap();
        classes.forEach(clazz -> {
            if (!clazz.isAnnotationPresent(TestEngine.BaseClass.class) && !Modifier.isAbstract(clazz.getModifiers()) && clazz.isAnnotationPresent(TestEngine.Order.class)) {
                int order = clazz.getAnnotation(TestEngine.Order.class).order();
                LOGGER.trace("clazz [%s] order [%d]", clazz.getName(), order);
                if (orderToClassMap.containsKey(order)) {
                    Class existingClass = (Class)orderToClassMap.get(order);
                    throw new TestClassConfigurationException(String.format("Test class [%s] (or superclass) and test class [%s] (or superclass) contain duplicate @TestEngine.Order(%d) class annotation", existingClass.getName(), clazz.getName(), order));
                }
                orderToClassMap.put(order, clazz);
            }
        });
    }

    public static void sortMethods(List<Method> methods) {
        methods.sort((o1, o2) -> {
            TestEngine.Order o1Annotation = o1.getAnnotation(TestEngine.Order.class);
            TestEngine.Order o2Annotation = o2.getAnnotation(TestEngine.Order.class);
            if (o1Annotation != null) {
                if (o2Annotation != null) {
                    int o1Order = o1Annotation.order();
                    int o2Order = o2Annotation.order();
                    return Integer.compare(o1Order, o2Order);
                }
                return -1;
            }
            if (o2Annotation != null) {
                return 1;
            }
            String o1DisplayName = ReflectionUtils.getDisplayName(o1);
            String o2DisplayName = ReflectionUtils.getDisplayName(o2);
            return o1DisplayName.compareTo(o2DisplayName);
        });
    }

    private static void validateDistinctOrder(Class<?> clazz, List<Method> methods) {
        HashSet integers = new HashSet();
        methods.forEach(method -> {
            TestEngine.Order annotation = method.getAnnotation(TestEngine.Order.class);
            if (annotation != null) {
                int value = annotation.order();
                if (integers.contains(value)) {
                    throw new TestClassConfigurationException(String.format("Test class [%s] (or superclass) contains a duplicate @TestEngine.Order(%d) method annotation", clazz.getName(), value));
                }
                integers.add(value);
            }
        });
    }

    private static String getAnnotationDisplayName(Class<? extends Annotation> annotation) {
        return String.format("@%s.%s", annotation.getDeclaringClass().getSimpleName(), annotation.getSimpleName());
    }

    private static enum Scope {
        STATIC,
        NON_STATIC;

    }
}

