/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.AutoCloseAnnotationUtils;
import org.antublue.test.engine.internal.ExecutorContext;
import org.antublue.test.engine.internal.LockAnnotationUtils;
import org.antublue.test.engine.internal.ReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class ArgumentTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument testArgument;

    ArgumentTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)ReflectionUtils.getArgumentSupplierMethod(this.testClass)));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    @Override
    public void execute(ExecutorContext executorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        EngineExecutionListener engineExecutionListener = executorContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        Object testInstance = executorContext.getTestInstance();
        ThrowableCollector throwableCollector = new ThrowableCollector();
        Field field = ReflectionUtils.getArgumentField(this.testClass);
        LOGGER.trace("set field testClass [%s] field [%s] testArgument [%s]", this.testClass.getName(), field.getName(), this.testArgument.name());
        ReflectionUtils.setField(testInstance, field, this.testArgument, throwableCollector);
        if (throwableCollector.isEmpty()) {
            List<Method> methods = ReflectionUtils.getBeforeAllMethods(this.testClass);
            for (Method method : methods) {
                LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
                LockAnnotationUtils.processLockAnnotations(method);
                ReflectionUtils.invoke(testInstance, method, throwableCollector);
                LockAnnotationUtils.processUnlockAnnotations(method);
                if (!throwableCollector.isNotEmpty()) continue;
                break;
            }
        }
        List methodTestDescriptors = this.getChildren(MethodTestDescriptor.class);
        if (throwableCollector.isEmpty()) {
            methodTestDescriptors.forEach(methodTestDescriptor -> methodTestDescriptor.execute(executorContext));
        } else {
            methodTestDescriptors.forEach(methodTestDescriptor -> {
                LOGGER.trace("skip uniqueId [%s] testClass [%s] testMethod [%s]", methodTestDescriptor.getUniqueId(), this.testClass.getName(), methodTestDescriptor.getTestMethod().getName());
                methodTestDescriptor.skip(executorContext);
            });
        }
        List<Method> methods = ReflectionUtils.getAfterAllMethods(this.testClass);
        for (Method method : methods) {
            LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
            LockAnnotationUtils.processLockAnnotations(method);
            ReflectionUtils.invoke(testInstance, method, throwableCollector);
            LockAnnotationUtils.processUnlockAnnotations(method);
        }
        AutoCloseAnnotationUtils.processAutoCloseAnnotatedFields(testInstance, "@TestEngine.AfterAll", throwableCollector);
        LOGGER.trace("set field testClass [%s] field [%s] testArgument[null]", this.testClass.getName(), field.getName());
        ReflectionUtils.setField(testInstance, field, null, throwable -> {});
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
    }
}

