/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.internal.AutoCloseAnnotationUtils;
import org.antublue.test.engine.internal.ExecutorContext;
import org.antublue.test.engine.internal.LockAnnotationUtils;
import org.antublue.test.engine.internal.ReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public final class ClassTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassTestDescriptor.class);
    private final Class<?> testClass;
    private Object testInstance;

    ClassTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass) {
        super(uniqueId, displayName);
        this.testClass = testClass;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public void execute(ExecutorContext executorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        EngineExecutionListener engineExecutionListener = executorContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        LOGGER.trace("instantiate testClass [%s]", (Object)this.testClass.getName());
        ReflectionUtils.instantiate(this.testClass, o -> {
            this.testInstance = o;
            executorContext.setTestInstance(this.testInstance);
        }, throwableCollector::add);
        if (throwableCollector.isEmpty()) {
            List<Method> methods = ReflectionUtils.getPrepareMethods(this.testClass);
            for (Method method : methods) {
                LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
                LockAnnotationUtils.processLockAnnotations(method);
                ReflectionUtils.invoke(this.testInstance, method, throwableCollector);
                LockAnnotationUtils.processUnlockAnnotations(method);
                if (!throwableCollector.isNotEmpty()) continue;
                break;
            }
        }
        List argumentTestDescriptors = this.getChildren(ArgumentTestDescriptor.class);
        if (throwableCollector.isEmpty()) {
            argumentTestDescriptors.forEach(argumentTestDescriptor -> argumentTestDescriptor.execute(executorContext));
        } else {
            argumentTestDescriptors.forEach(argumentTestDescriptor -> {
                LOGGER.trace("skip uniqueId [%s] testClass [%s] testArgument [%s]", argumentTestDescriptor.getUniqueId(), this.testClass.getName(), argumentTestDescriptor.getTestArgument().name());
                argumentTestDescriptor.skip(executorContext);
            });
        }
        if (this.testInstance != null) {
            List<Method> methods = ReflectionUtils.getConcludeMethods(this.testClass);
            for (Method method : methods) {
                LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
                LockAnnotationUtils.processLockAnnotations(method);
                ReflectionUtils.invoke(this.testInstance, method, throwableCollector);
                LockAnnotationUtils.processUnlockAnnotations(method);
            }
            AutoCloseAnnotationUtils.processAutoCloseAnnotatedFields(this.testInstance, "@TestEngine.Conclude", throwableCollector);
        }
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
        this.testInstance = null;
        executorContext.complete();
    }
}

