/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.ReflectionUtils;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.Switch;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public final class TestDescriptorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestDescriptorUtils.class);

    private TestDescriptorUtils() {
    }

    public static ClassTestDescriptor createClassTestDescriptor(UniqueId uniqueId, Class<?> clazz) {
        TestDescriptorUtils.validateTestClass(clazz);
        return new ClassTestDescriptor(uniqueId, ReflectionUtils.getDisplayName(clazz), clazz);
    }

    public static ArgumentTestDescriptor createArgumentTestDescriptor(UniqueId uniqueId, Class<?> clazz, Argument argument) {
        TestDescriptorUtils.validateTestClass(clazz);
        return new ArgumentTestDescriptor(uniqueId, argument.name(), clazz, argument);
    }

    public static MethodTestDescriptor createMethodTestDescriptor(UniqueId uniqueId, Class<?> clazz, Argument argument, Method method) {
        TestDescriptorUtils.validateTestClass(clazz);
        return new MethodTestDescriptor(uniqueId, ReflectionUtils.getDisplayName(method), clazz, argument, method);
    }

    public static void logTestDescriptorTree(TestDescriptor testDescriptor) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("--------------------");
            LOGGER.trace("Test descriptor tree");
            LOGGER.trace("--------------------");
            TestDescriptorUtils.logTestDescriptorTree(testDescriptor, 0);
            LOGGER.trace("------------------------");
        }
    }

    private static void logTestDescriptorTree(TestDescriptor testDescriptor, int indent) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            stringBuilder.append(" ");
        }
        Switch.switchType(testDescriptor, Switch.switchCase(MethodTestDescriptor.class, methodTestDescriptor -> stringBuilder.append("method -> ").append(methodTestDescriptor.getUniqueId()).append("()")), Switch.switchCase(ArgumentTestDescriptor.class, argumentTestDescriptor -> stringBuilder.append("argument -> ").append(argumentTestDescriptor.getUniqueId())), Switch.switchCase(ClassTestDescriptor.class, classTestDescriptor -> stringBuilder.append("class -> ").append(classTestDescriptor.getUniqueId())), Switch.switchCase(EngineDescriptor.class, engineDescriptor -> stringBuilder.append("engine -> ").append(engineDescriptor.getDisplayName())));
        LOGGER.trace(stringBuilder.toString());
        testDescriptor.getChildren().forEach(t -> TestDescriptorUtils.logTestDescriptorTree(t, indent + 2));
    }

    private static void validateTestClass(Class<?> clazz) {
        if (ReflectionUtils.getArgumentSupplierMethod(clazz) == null) {
            throw new TestClassConfigurationException(String.format("Test class [%s] must declare a static @TestEngine.ArgumentSupplier method", clazz.getName()));
        }
        if (ReflectionUtils.getArgumentField(clazz) == null) {
            throw new TestClassConfigurationException(String.format("Test class [%s] must declare a @TestEngine.Argument field", clazz.getName()));
        }
        if (ReflectionUtils.getTestMethods(clazz).size() < 1) {
            throw new TestClassConfigurationException(String.format("Test class [%s] must declare a @TestEngine.Test method", clazz.getName()));
        }
        ReflectionUtils.getPrepareMethods(clazz);
        ReflectionUtils.getBeforeAllMethods(clazz);
        ReflectionUtils.getBeforeEachMethods(clazz);
        ReflectionUtils.getAfterEachMethods(clazz);
        ReflectionUtils.getAfterAllMethods(clazz);
        ReflectionUtils.getConcludeMethods(clazz);
    }
}

