/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.ReflectionUtils;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public class AutoCloseAnnotationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoCloseAnnotationUtils.class);
    private static final AutoCloseAnnotationUtils SINGLETON = new AutoCloseAnnotationUtils();

    private AutoCloseAnnotationUtils() {
    }

    public static AutoCloseAnnotationUtils singleton() {
        return SINGLETON;
    }

    public void processAutoCloseAnnotatedFields(Object object, String lifecycle, Consumer<Throwable> throwableConsumer) {
        LOGGER.trace("processAutoCloseFields(%s, %s)", object.getClass().getName(), lifecycle);
        ReflectionUtils.getAutoCloseFields(object.getClass()).forEach(field -> {
            LOGGER.trace("closing field [%s]", (Object)field.getName());
            TestEngine.AutoClose annotation = field.getAnnotation(TestEngine.AutoClose.class);
            String annotationLifecycle = annotation.lifecycle();
            String annotationMethodName = annotation.method();
            if (lifecycle.equals(annotationLifecycle)) {
                this.close(object, annotationLifecycle, annotationMethodName, (Field)field, throwableConsumer);
            } else {
                LOGGER.trace("skipping field [%s] annotation scope [%s] doesn't match scope [%s]", field.getName(), annotationLifecycle, lifecycle);
            }
        });
    }

    private void close(Object object, String lifecycle, String methodName, Field field, Consumer<Throwable> throwableConsumer) {
        LOGGER.trace("close(%s, %s, %s)", object.getClass().getName(), methodName, field.getName());
        if (methodName == null || methodName.trim().isEmpty()) {
            try {
                Object o = field.get(object);
                if (o instanceof AutoCloseable) {
                    ((AutoCloseable)o).close();
                }
            }
            catch (Throwable t) {
                throwableConsumer.accept(new TestEngineException(String.format("Exception closing @TestEngine.AutoClose class [%s] field [%s] scope [%s]", object.getClass(), field.getName(), lifecycle), t));
            }
        } else {
            Throwable throwable = null;
            try {
                Object o = field.get(object);
                if (o != null) {
                    Method method = o.getClass().getMethod(methodName.trim(), null);
                    method.setAccessible(true);
                    method.invoke(o, (Object[])null);
                }
            }
            catch (InvocationTargetException e) {
                throwable = e.getCause();
            }
            catch (Throwable t) {
                throwable = t;
            }
            if (throwable != null) {
                throwableConsumer.accept(new TestEngineException(String.format("Exception closing @TestEngine.AutoClose class [%s] field [%s] method [%s] scope [%s]", object.getClass(), field.getName(), methodName.trim(), lifecycle), throwable));
            }
        }
    }
}

