/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public class ConfigurationParameters
implements org.junit.platform.engine.ConfigurationParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationParameters.class);
    private static final String USER_HOME = System.getProperty("user.home");
    private final Properties properties;
    private final Map<String, Optional> cache = Collections.synchronizedMap(new HashMap());

    public ConfigurationParameters() {
        this.properties = new Properties();
        LOGGER.trace("[%s] = [%s]", "user.home", USER_HOME);
        String propertiesFilename = null;
        String value = System.getenv("antublue.test.engine.properties".toUpperCase(Locale.ENGLISH).replace('.', '_'));
        if (value != null && !value.trim().isEmpty()) {
            propertiesFilename = value.trim();
        }
        if (propertiesFilename == null && (value = System.getProperty("antublue.test.engine.properties")) != null && !value.trim().isEmpty()) {
            propertiesFilename = value.trim();
        }
        if (propertiesFilename == null && USER_HOME != null) {
            propertiesFilename = USER_HOME + "/.antublue-test-engine.properties";
        }
        LOGGER.trace("[%s] = [%s]", "antublue.test.engine.properties", propertiesFilename);
        File file = new File(propertiesFilename);
        if (file.exists() && file.isFile() && file.canRead()) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(file.toPath().toAbsolutePath());){
                this.properties.load(bufferedReader);
            }
            catch (IOException e) {
                LOGGER.warn("Exception loading test engine properties [%s]", (Object)file.toPath().toAbsolutePath());
            }
        }
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.resolve(key));
    }

    public Optional<Boolean> getBoolean(String key) {
        return Optional.of(Boolean.parseBoolean(this.resolve(key)));
    }

    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        String value = this.resolve(key);
        T t = transformer.apply(value);
        return Optional.ofNullable(t);
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    private String resolve(String key) {
        LOGGER.trace("resolve [%s]", (Object)key);
        String location = null;
        Optional cachedResult = this.cache.get(key);
        if (cachedResult != null) {
            if (cachedResult.isPresent()) {
                return (String)cachedResult.get();
            }
            return null;
        }
        String result = null;
        String value = System.getenv(key.toUpperCase(Locale.ENGLISH).replace('.', '_'));
        if (value != null && !value.trim().isEmpty()) {
            result = value.trim();
            location = "environment variable";
        }
        if (result == null && (value = System.getProperty(key)) != null && !value.trim().isEmpty()) {
            result = value.trim();
            location = "system property";
        }
        if (result == null && (value = this.properties.getProperty(key)) != null && !value.trim().isEmpty()) {
            result = value.trim();
            location = "properties file";
        }
        if (result == null) {
            location = "not found";
        }
        LOGGER.trace("[%s] = [%s] (location [%s])", key, result, location);
        this.cache.put(key, Optional.ofNullable(result));
        return result;
    }
}

