/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.ReflectionUtils;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestDescriptorUtils;
import org.antublue.test.engine.internal.discovery.predicate.TestClassPredicate;
import org.antublue.test.engine.internal.discovery.predicate.TestClassTagPredicate;
import org.antublue.test.engine.internal.discovery.predicate.TestMethodPredicate;
import org.antublue.test.engine.internal.discovery.predicate.TestMethodTagPredicate;
import org.antublue.test.engine.internal.discovery.resolver.ClassNameFiltersPredicate;
import org.antublue.test.engine.internal.discovery.resolver.PackageNameFiltersPredicate;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class Resolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(Resolver.class);
    private TestClassPredicate includeTestClassPredicate;
    private TestClassPredicate excludeTestClassPredicate;
    private TestMethodPredicate includeTestMethodPredicate;
    private TestMethodPredicate excludeTestMethodPredicate;
    private TestClassTagPredicate includeTestClassTagPredicate;
    private TestClassTagPredicate excludeTestClassTagPredicate;
    private TestMethodTagPredicate includeTestMethodTagPredicate;
    private TestMethodTagPredicate excludeTestMethodTagPredicate;
    private ClassNameFiltersPredicate classNameFiltersPredicate;
    private PackageNameFiltersPredicate packageNameFiltersPredicate;
    private Map<Class<?>, Set<Method>> classMethodSetMap;
    private ConfigurationParameters configurationParameters;
    private EngineDiscoveryRequest engineDiscoveryRequest;
    private EngineDescriptor engineDescriptor;
    private static final Predicate<Class<?>> IS_TEST_CLASS = clazz -> {
        if (clazz.isAnnotationPresent(TestEngine.BaseClass.class) || clazz.isAnnotationPresent(TestEngine.Disabled.class) || Modifier.isAbstract(clazz.getModifiers()) || ReflectionUtils.getTestMethods(clazz).isEmpty()) {
            LOGGER.trace("is test class [%s] excluded", (Object)clazz.getName());
            return false;
        }
        LOGGER.trace("class [%s] included", (Object)clazz.getName());
        return true;
    };
    private static final Predicate<Method> IS_TEST_METHOD = method -> {
        boolean result = !method.isAnnotationPresent(TestEngine.Disabled.class) && ReflectionUtils.getTestMethods(method.getDeclaringClass()).contains(method);
        LOGGER.trace("is test method [%s] = [%b]", method.getDeclaringClass().getName(), result);
        return result;
    };

    public void resolve(EngineDiscoveryRequest engineDiscoveryRequest, ConfigurationParameters configurationParameters, EngineDescriptor engineDescriptor) {
        this.engineDiscoveryRequest = engineDiscoveryRequest;
        this.configurationParameters = configurationParameters;
        this.engineDescriptor = engineDescriptor;
        this.configure();
        this.resolve();
        this.filter();
    }

    private void configure() {
        LOGGER.trace("configure()");
        this.configureIncludeTestClassPredicate();
        this.configureExcludeTestClassPredicate();
        this.configureIncludeTestMethodPredicate();
        this.configureExcludeTestMethodPredicate();
        this.configureIncludeTestClassTagPredicate();
        this.configureExcludeTestClassTagPredicate();
        this.configureIncludeTestMethodTagPredicate();
        this.configureExcludeTestMethodTagPredicate();
        this.configureClassNameFiltersPredicate();
        this.configurePackageNameFiltersPredicate();
    }

    private void configureIncludeTestClassPredicate() {
        LOGGER.trace("configureIncludeTestClassPredicate()");
        this.includeTestClassPredicate = this.configurationParameters.get("antublue.test.engine.test.class.include").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.include", value);
            return value;
        }).map(TestClassPredicate::of).orElse(null);
    }

    private void configureExcludeTestClassPredicate() {
        LOGGER.trace("configureExcludeTestClassPredicate()");
        this.excludeTestClassPredicate = this.configurationParameters.get("antublue.test.engine.test.class.exclude").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.exclude", value);
            return value;
        }).map(TestClassPredicate::of).orElse(null);
    }

    private void configureIncludeTestMethodPredicate() {
        LOGGER.trace("configureIncludeTestMethodPredicate()");
        this.includeTestMethodPredicate = this.configurationParameters.get("antublue.test.engine.test.method.include").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.include", value);
            return value;
        }).map(TestMethodPredicate::of).orElse(null);
    }

    private void configureExcludeTestMethodPredicate() {
        LOGGER.trace("configureExcludeTestMethodPredicate()");
        this.excludeTestMethodPredicate = this.configurationParameters.get("antublue.test.engine.test.method.exclude").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.exclude", value);
            return value;
        }).map(TestMethodPredicate::of).orElse(null);
    }

    private void configureIncludeTestClassTagPredicate() {
        LOGGER.trace("configureIncludeTestClassTagPredicate()");
        this.includeTestClassTagPredicate = this.configurationParameters.get("antublue.test.engine.test.class.tag.include").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.tag.include", value);
            return value;
        }).map(TestClassTagPredicate::of).orElse(null);
    }

    private void configureExcludeTestClassTagPredicate() {
        LOGGER.trace("configureExcludeTestClassTagPredicate()");
        this.excludeTestClassTagPredicate = this.configurationParameters.get("antublue.test.engine.test.class.tag.exclude").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.class.tag.exclude", value);
            return value;
        }).map(TestClassTagPredicate::of).orElse(null);
    }

    private void configureIncludeTestMethodTagPredicate() {
        LOGGER.trace("configureIncludeTestMethodTagPredicate()");
        this.includeTestMethodTagPredicate = this.configurationParameters.get("antublue.test.engine.test.method.tag.include").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.tag.include", value);
            return value;
        }).map(TestMethodTagPredicate::of).orElse(null);
    }

    private void configureExcludeTestMethodTagPredicate() {
        LOGGER.trace("configureExcludeTestMethodTagPredicate()");
        this.excludeTestMethodTagPredicate = this.configurationParameters.get("antublue.test.engine.test.method.tag.exclude").map(value -> {
            LOGGER.trace("%s [%s]", "antublue.test.engine.test.method.tag.exclude", value);
            return value;
        }).map(TestMethodTagPredicate::of).orElse(null);
    }

    private void configureClassNameFiltersPredicate() {
        LOGGER.trace("configureClassNameFiltersPredicate()");
        List classNameFilters = this.engineDiscoveryRequest.getFiltersByType(ClassNameFilter.class);
        LOGGER.trace("classNameFilters count [%d]", (Object)classNameFilters.size());
        this.classNameFiltersPredicate = new ClassNameFiltersPredicate(classNameFilters);
    }

    private void configurePackageNameFiltersPredicate() {
        LOGGER.trace("configurePackageNameFiltersPredicate()");
        List packageNameFilters = this.engineDiscoveryRequest.getFiltersByType(PackageNameFilter.class);
        LOGGER.trace("packageNameFilters count [%d]", (Object)packageNameFilters.size());
        this.packageNameFiltersPredicate = new PackageNameFiltersPredicate(packageNameFilters);
    }

    private void resolve() {
        LOGGER.trace("resolve()");
        this.classMethodSetMap = new LinkedHashMap();
        this.resolveClasspathRootSelectors();
        this.resolvePackageSelectors();
        this.resolveClassSelectors();
        this.resolveMethodSelectors();
        this.resolveUniqueIdSelectors();
    }

    private void resolveClasspathRootSelectors() {
        LOGGER.trace("resolveClasspathRootSelectors()");
        this.engineDiscoveryRequest.getSelectorsByType(ClasspathRootSelector.class).forEach(classpathRootSelector -> {
            LOGGER.trace("ClasspathRootSelector.class");
            ReflectionUtils.findAllClasses(classpathRootSelector.getClasspathRoot()).forEach(clazz -> {
                if (IS_TEST_CLASS.test((Class<?>)clazz) && this.packageNameFiltersPredicate.test((Class<?>)clazz) && this.classNameFiltersPredicate.test((Class<?>)clazz)) {
                    this.classMethodSetMap.put((Class<?>)clazz, (Set<Method>)new LinkedHashSet<Method>(ReflectionUtils.getTestMethods(clazz)));
                }
            });
        });
    }

    private void resolvePackageSelectors() {
        LOGGER.trace("resolvePackageSelectors()");
        this.engineDiscoveryRequest.getSelectorsByType(PackageSelector.class).forEach(packageSelector -> {
            LOGGER.trace("PackageSelector.class");
            ReflectionUtils.findAllClasses(packageSelector.getPackageName()).forEach(clazz -> {
                if (IS_TEST_CLASS.test((Class<?>)clazz) && this.packageNameFiltersPredicate.test((Class<?>)clazz) && this.classNameFiltersPredicate.test((Class<?>)clazz)) {
                    this.classMethodSetMap.put((Class<?>)clazz, (Set<Method>)new LinkedHashSet<Method>(ReflectionUtils.getTestMethods(clazz)));
                }
            });
        });
    }

    private void resolveClassSelectors() {
        LOGGER.trace("resolveClassSelectors()");
        this.engineDiscoveryRequest.getSelectorsByType(ClassSelector.class).forEach(classSelector -> {
            LOGGER.trace("ClassSelector.class");
            Class clazz = classSelector.getJavaClass();
            if (IS_TEST_CLASS.test(clazz) && this.packageNameFiltersPredicate.test(clazz) && this.classNameFiltersPredicate.test(clazz)) {
                this.classMethodSetMap.put(clazz, new LinkedHashSet<Method>(ReflectionUtils.getTestMethods(clazz)));
            }
        });
    }

    private void resolveMethodSelectors() {
        LOGGER.trace("resolveMethodSelectors()");
        this.engineDiscoveryRequest.getSelectorsByType(MethodSelector.class).forEach(methodSelector -> {
            LOGGER.trace("MethodSelector.class");
            Class clazz = methodSelector.getJavaClass();
            if (IS_TEST_METHOD.test(methodSelector.getJavaMethod()) && this.packageNameFiltersPredicate.test(clazz) && this.classNameFiltersPredicate.test(clazz)) {
                Set methods = this.classMethodSetMap.getOrDefault(clazz, new LinkedHashSet());
                methods.add(methodSelector.getJavaMethod());
                this.classMethodSetMap.put(clazz, methods);
            }
        });
    }

    private void resolveUniqueIdSelectors() {
        LOGGER.trace("resolveUniqueIdSelectors()");
        this.engineDiscoveryRequest.getSelectorsByType(UniqueIdSelector.class).forEach(uniqueIdSelector -> {
            LOGGER.trace("UniqueIdSelector.class");
            UniqueId.Segment segment = uniqueIdSelector.getUniqueId().getLastSegment();
            if ("class".equals(segment.getType())) {
                String className = segment.getValue();
                try {
                    Class<?> clazz = Class.forName(className);
                    if (!IS_TEST_CLASS.test(clazz) || !this.packageNameFiltersPredicate.test(clazz) || !this.classNameFiltersPredicate.test(clazz)) return;
                    Set methods = this.classMethodSetMap.getOrDefault(clazz, new LinkedHashSet());
                    methods.addAll(ReflectionUtils.getTestMethods(clazz));
                    this.classMethodSetMap.put(clazz, methods);
                    return;
                }
                catch (ClassNotFoundException e) {
                    throw new TestEngineException(String.format("Exception loading class [%s]", className));
                }
            }
            if (!"argument".equals(segment.getType())) return;
            segment = uniqueIdSelector.getUniqueId().removeLastSegment().getLastSegment();
            String className = segment.getValue();
            try {
                Class<?> clazz = Class.forName(className);
                if (!IS_TEST_CLASS.test(clazz) || !this.packageNameFiltersPredicate.test(clazz) || !this.classNameFiltersPredicate.test(clazz)) return;
                Set methods = this.classMethodSetMap.getOrDefault(clazz, new LinkedHashSet());
                methods.addAll(ReflectionUtils.getTestMethods(clazz));
                this.classMethodSetMap.put(clazz, methods);
                return;
            }
            catch (ClassNotFoundException e) {
                throw new TestEngineException(String.format("Exception loading class [%s]", className));
            }
        });
    }

    private void filter() {
        LOGGER.trace("filter()");
        Iterator<Map.Entry<Class<?>, Set<Method>>> classMethodMapEntryIterator = this.classMethodSetMap.entrySet().iterator();
        while (classMethodMapEntryIterator.hasNext()) {
            Map.Entry<Class<?>, Set<Method>> entry = classMethodMapEntryIterator.next();
            Class<?> clazz = entry.getKey();
            Set<Method> methods = entry.getValue();
            if (this.includeTestClassPredicate != null) {
                if (this.includeTestClassPredicate.test(clazz)) {
                    LOGGER.trace("includeTestClassPredicate class [%s] included", (Object)clazz.getName());
                } else {
                    LOGGER.trace("includeTestClassPredicate class [%s] excluded", (Object)clazz.getName());
                    classMethodMapEntryIterator.remove();
                    continue;
                }
            }
            if (this.excludeTestClassPredicate != null) {
                if (this.excludeTestClassPredicate.test(clazz)) {
                    LOGGER.trace("excludeTestClassPredicate class [%s] excluded", (Object)clazz.getName());
                    classMethodMapEntryIterator.remove();
                    continue;
                }
                LOGGER.trace("excludeTestClassPredicate class [%s] included", (Object)clazz.getName());
            }
            if (this.includeTestClassTagPredicate != null) {
                if (this.includeTestClassTagPredicate.test(clazz)) {
                    LOGGER.trace("includeTestClassTagPredicate class [%s] included", (Object)clazz.getName());
                } else {
                    LOGGER.trace("includeTestClassTagPredicate class [%s] excluded", (Object)clazz.getName());
                    classMethodMapEntryIterator.remove();
                    continue;
                }
            }
            if (this.excludeTestClassTagPredicate != null) {
                if (this.excludeTestClassTagPredicate.test(clazz)) {
                    LOGGER.trace("excludeTestClassTagPredicate class [%s] excluded", (Object)clazz.getName());
                    classMethodMapEntryIterator.remove();
                    continue;
                }
                LOGGER.trace("excludeTestClassTagPredicate class [%s] included", (Object)clazz.getName());
            }
            Iterator<Method> methodIterator = methods.iterator();
            while (methodIterator.hasNext()) {
                Method method = methodIterator.next();
                if (this.includeTestMethodPredicate != null) {
                    if (this.includeTestMethodPredicate.test(method)) {
                        LOGGER.trace("includeTestMethodPredicate class [%s] included", (Object)method.getName());
                    } else {
                        LOGGER.trace("includeTestMethodPredicate class [%s] excluded", (Object)method.getName());
                        methodIterator.remove();
                        continue;
                    }
                }
                if (this.excludeTestMethodPredicate != null) {
                    if (this.excludeTestMethodPredicate.test(method)) {
                        LOGGER.trace("excludeTestMethodPredicate class [%s] excluded", (Object)method.getName());
                        methodIterator.remove();
                        continue;
                    }
                    LOGGER.trace("excludeTestMethodPredicate class [%s] included", (Object)method.getName());
                }
                if (this.includeTestMethodTagPredicate != null) {
                    if (this.includeTestMethodTagPredicate.test(method)) {
                        LOGGER.trace("includeTestMethodTagPredicate class [%s] included", (Object)method.getName());
                    } else {
                        LOGGER.trace("includeTestMethodTagPredicate class [%s] excluded", (Object)method.getName());
                        methodIterator.remove();
                        continue;
                    }
                }
                if (this.excludeTestMethodTagPredicate == null) continue;
                if (this.excludeTestMethodTagPredicate.test(method)) {
                    LOGGER.trace("excludeTestMethodTagPredicate class [%s] excluded", (Object)method.getName());
                    methodIterator.remove();
                    continue;
                }
                LOGGER.trace("excludeTestMethodTagPredicate class [%s] included", (Object)method.getName());
            }
            if (methods.isEmpty()) {
                LOGGER.trace("class [%s] has no test methods, ignoring", (Object)clazz.getName());
                classMethodMapEntryIterator.remove();
                continue;
            }
            LOGGER.trace("building test descriptor tree for class [%s]", (Object)clazz.getName());
            UniqueId classTestDescritporUniqueId = this.engineDescriptor.getUniqueId().append("class", clazz.getName());
            ClassTestDescriptor classTestDescriptor = TestDescriptorUtils.createClassTestDescriptor(classTestDescritporUniqueId, clazz);
            this.engineDescriptor.addChild((TestDescriptor)classTestDescriptor);
            List<Argument> arguments = ReflectionUtils.getArgumentsList(clazz);
            for (Argument argument : arguments) {
                UniqueId argumentUniqueId = classTestDescritporUniqueId.append("argument", argument.name());
                ArgumentTestDescriptor argumentTestDescriptor = TestDescriptorUtils.createArgumentTestDescriptor(argumentUniqueId, clazz, argument);
                classTestDescriptor.addChild((TestDescriptor)argumentTestDescriptor);
                for (Method method : methods) {
                    UniqueId methodUniqueId = argumentUniqueId.append("method", method.getName());
                    MethodTestDescriptor methodTestDescriptor = TestDescriptorUtils.createMethodTestDescriptor(methodUniqueId, clazz, argument, method);
                    argumentTestDescriptor.addChild((TestDescriptor)methodTestDescriptor);
                }
            }
        }
        TestDescriptorUtils.logTestDescriptorTree((TestDescriptor)this.engineDescriptor);
    }
}

