/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public final class TestDescriptorStore {
    private static final TestDescriptorStore SINGLETON = new TestDescriptorStore();
    private final Map<UniqueId, TestDescriptor> testDescriptorMap = new LinkedHashMap<UniqueId, TestDescriptor>();

    private TestDescriptorStore() {
    }

    public static TestDescriptorStore singleton() {
        return SINGLETON;
    }

    public void store(EngineDescriptor engineDescriptor) {
        this.recursivelyStore((TestDescriptor)engineDescriptor);
    }

    public Optional<TestDescriptor> get(UniqueId uniqueId) {
        return Optional.ofNullable(this.testDescriptorMap.get(uniqueId));
    }

    private void recursivelyStore(TestDescriptor testDescriptor) {
        this.testDescriptorMap.put(testDescriptor.getUniqueId(), testDescriptor);
        testDescriptor.getChildren().forEach(this::recursivelyStore);
    }
}

