/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.AutoCloseAnnotationUtils;
import org.antublue.test.engine.internal.ExecutorContext;
import org.antublue.test.engine.internal.LockAnnotationUtils;
import org.antublue.test.engine.internal.ReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.StateMachine;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class ArgumentTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument testArgument;

    ArgumentTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)ReflectionUtils.getArgumentSupplierMethod(this.testClass)));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    @Override
    public void execute(ExecutorContext executorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        EngineExecutionListener engineExecutionListener = executorContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        Object testInstance = executorContext.getTestInstance();
        ThrowableCollector throwableCollector = new ThrowableCollector();
        LockAnnotationUtils lockAnnotationUtils = LockAnnotationUtils.singleton();
        StateMachine<State> stateMachine = new StateMachine<State>(this.toString(), State.SET_FIELD);
        ReflectionUtils.getArgumentField(this.testClass).ifPresent(field -> {
            LOGGER.trace("set argument field testClass [%s] field [%s] testArgument [%s]", this.testClass.getName(), field.getName(), this.testArgument.name());
            ReflectionUtils.setField(testInstance, field, this.testArgument, throwableCollector);
            stateMachine.ifTrueThenElse(throwableCollector.isEmpty(), State.SET_FIELD_SUCCESS, State.SET_FIELD_FAIL);
        });
        stateMachine.ifThen(State.SET_FIELD, State.SET_FIELD_SUCCESS);
        if (stateMachine.ifThen(State.SET_FIELD_SUCCESS, State.BEFORE_ALL)) {
            List<Method> methods = ReflectionUtils.getBeforeAllMethods(this.testClass);
            for (Method method : methods) {
                LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
                lockAnnotationUtils.processLockAnnotations(method);
                boolean acceptsArgument = ReflectionUtils.acceptsArgument(method, this.testArgument);
                LOGGER.trace("class [%s] method [%s] acceptsArgument [%b]", this.testClass.getName(), method.getName(), acceptsArgument);
                if (acceptsArgument) {
                    ReflectionUtils.invoke(testInstance, method, new Object[]{this.testArgument}, throwableCollector);
                } else {
                    ReflectionUtils.invoke(testInstance, method, throwableCollector);
                }
                lockAnnotationUtils.processUnlockAnnotations(method);
                if (!throwableCollector.isNotEmpty()) continue;
                break;
            }
            stateMachine.ifTrueThenElse(throwableCollector.isEmpty(), State.BEFORE_ALL_SUCCESS, State.BEFORE_ALL_FAIL);
        }
        List methodTestDescriptors = this.getChildren(MethodTestDescriptor.class);
        if (stateMachine.ifThen(State.BEFORE_ALL_SUCCESS, State.EXECUTE)) {
            methodTestDescriptors.forEach(methodTestDescriptor -> methodTestDescriptor.execute(executorContext));
            stateMachine.set(State.EXECUTE_SUCCESS);
        }
        if (stateMachine.ifThen(State.BEFORE_ALL_FAIL, State.SKIP)) {
            methodTestDescriptors.forEach(methodTestDescriptor -> {
                LOGGER.trace("skip uniqueId [%s] testClass [%s] testMethod [%s]", methodTestDescriptor.getUniqueId(), this.testClass.getName(), methodTestDescriptor.getTestMethod().getName());
                methodTestDescriptor.skip(executorContext);
            });
            stateMachine.set(State.SKIP_SUCCESS);
        }
        if (stateMachine.ifNotThen(State.SET_FIELD_FAIL, State.AFTER_ALL)) {
            List<Method> methods = ReflectionUtils.getAfterAllMethods(this.testClass);
            for (Method method : methods) {
                LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
                lockAnnotationUtils.processLockAnnotations(method);
                boolean acceptsArgument = ReflectionUtils.acceptsArgument(method, this.testArgument);
                LOGGER.trace("class [%s] method [%s] acceptsArgument [%b]", this.testClass.getName(), method.getName(), acceptsArgument);
                if (acceptsArgument) {
                    ReflectionUtils.invoke(testInstance, method, new Object[]{this.testArgument}, throwableCollector);
                } else {
                    ReflectionUtils.invoke(testInstance, method, throwableCollector);
                }
                lockAnnotationUtils.processUnlockAnnotations(method);
            }
            stateMachine.set(State.AFTER_ALL_SUCCESS);
        }
        AutoCloseAnnotationUtils.singleton().processAutoCloseAnnotatedFields(testInstance, "@TestEngine.AfterAll", throwableCollector);
        ReflectionUtils.getArgumentField(this.testClass).ifPresent(field -> {
            LOGGER.trace("set argument field testClass [%s] field [%s] testArgument [%s]", this.testClass.getName(), field.getName(), null);
            ReflectionUtils.setField(testInstance, field, null, throwableCollector);
        });
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
    }

    private static enum State {
        SET_FIELD,
        SET_FIELD_SUCCESS,
        SET_FIELD_FAIL,
        BEFORE_ALL,
        BEFORE_ALL_SUCCESS,
        BEFORE_ALL_FAIL,
        EXECUTE,
        EXECUTE_SUCCESS,
        SKIP,
        SKIP_SUCCESS,
        AFTER_ALL,
        AFTER_ALL_SUCCESS;

    }
}

