/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.AutoCloseAnnotationUtils;
import org.antublue.test.engine.internal.ExecutorContext;
import org.antublue.test.engine.internal.LockAnnotationUtils;
import org.antublue.test.engine.internal.ReflectionUtils;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.StateMachine;
import org.antublue.test.engine.internal.util.ThrowableCollector;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class MethodTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument testArgument;
    private final Method testMethod;

    MethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument testArgument, Method testMethod) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
        this.testMethod = testMethod;
        testMethod.setAccessible(true);
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public boolean isTest() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    @Override
    public void execute(ExecutorContext executorContext) {
        boolean acceptsArgument;
        LOGGER.trace("execute uniqueId [%s] testClass [%s] testArgument [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name(), this.testMethod.getName());
        EngineExecutionListener engineExecutionListener = executorContext.getExecutionRequest().getEngineExecutionListener();
        engineExecutionListener.executionStarted((TestDescriptor)this);
        ThrowableCollector throwableCollector = new ThrowableCollector();
        LockAnnotationUtils lockAnnotationUtils = LockAnnotationUtils.singleton();
        Object testInstance = executorContext.getTestInstance();
        StateMachine<State> stateMachine = new StateMachine<State>(this.toString(), State.BEFORE_EACH);
        List<Method> methods = ReflectionUtils.getBeforeEachMethods(this.testClass);
        for (Method method : methods) {
            LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
            lockAnnotationUtils.processLockAnnotations(method);
            acceptsArgument = ReflectionUtils.acceptsArgument(method, this.testArgument);
            LOGGER.trace("class [%s] method [%s] acceptsArgument [%b]", this.testClass.getName(), method.getName(), acceptsArgument);
            if (acceptsArgument) {
                ReflectionUtils.invoke(testInstance, method, new Object[]{this.testArgument}, throwableCollector);
            } else {
                ReflectionUtils.invoke(testInstance, method, throwableCollector);
            }
            lockAnnotationUtils.processUnlockAnnotations(method);
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
        stateMachine.ifTrueThenElse(throwableCollector.isEmpty(), State.BEFORE_EACH_SUCCESS, State.BEFORE_EACH_FAIL);
        if (stateMachine.ifThen(State.BEFORE_EACH_SUCCESS, State.EXECUTE)) {
            LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName());
            lockAnnotationUtils.processLockAnnotations(this.testMethod);
            boolean acceptsArgument2 = ReflectionUtils.acceptsArgument(this.testMethod, this.testArgument);
            LOGGER.trace("class [%s] method [%s] acceptsArgument [%b]", this.testClass.getName(), this.testMethod.getName(), acceptsArgument2);
            if (acceptsArgument2) {
                ReflectionUtils.invoke(testInstance, this.testMethod, new Object[]{this.testArgument}, throwableCollector);
            } else {
                ReflectionUtils.invoke(testInstance, this.testMethod, throwableCollector);
            }
            lockAnnotationUtils.processUnlockAnnotations(this.testMethod);
            stateMachine.ifTrueThenElse(throwableCollector.isEmpty(), State.EXECUTE_SUCCESS, State.EXECUTE_FAIL);
        }
        methods = ReflectionUtils.getAfterEachMethods(this.testClass);
        for (Method method : methods) {
            LOGGER.trace("invoke uniqueId [%s] testClass [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), method.getName());
            lockAnnotationUtils.processLockAnnotations(method);
            acceptsArgument = ReflectionUtils.acceptsArgument(method, this.testArgument);
            LOGGER.trace("class [%s] method [%s] acceptsArgument [%b]", this.testClass.getName(), method.getName(), acceptsArgument);
            if (acceptsArgument) {
                ReflectionUtils.invoke(testInstance, method, new Object[]{this.testArgument}, throwableCollector);
            } else {
                ReflectionUtils.invoke(testInstance, method, throwableCollector);
            }
            lockAnnotationUtils.processUnlockAnnotations(method);
        }
        AutoCloseAnnotationUtils.singleton().processAutoCloseAnnotatedFields(testInstance, "@TestEngine.AfterEach", throwableCollector);
        if (throwableCollector.isEmpty()) {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)throwableCollector.getFirst().orElse(null)));
        }
    }

    private static enum State {
        BEFORE_EACH,
        BEFORE_EACH_SUCCESS,
        BEFORE_EACH_FAIL,
        EXECUTE,
        EXECUTE_SUCCESS,
        EXECUTE_FAIL,
        AFTER_EACH,
        AFTER_EACH_SUCCESS,
        AFTER_EACH_FAIL;

    }
}

