/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public class StateMachine<T extends Enum> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateMachine.class);
    private final String name;
    private T state;

    public StateMachine(String name, T state) {
        LOGGER.trace("StateMachine name [%s] state [%s]", name, state);
        this.name = name;
        this.state = state;
    }

    public String name() {
        return this.name;
    }

    public T state() {
        return this.state;
    }

    public void set(T state) {
        LOGGER.trace("set state [%s]", (Object)state);
        this.state = state;
    }

    public boolean ifThen(T checkState, T nextState) {
        T currentState = this.state;
        boolean result = false;
        if (this.state == checkState) {
            this.state = nextState;
            result = true;
        }
        LOGGER.trace("ifThen state [%s] checkState [%s] nextState [%s] result (%b) new state [%s]", currentState, checkState, nextState, result, this.state);
        return result;
    }

    public boolean ifNotThen(T checkState, T nextState) {
        T currentState = this.state;
        boolean result = false;
        if (this.state != checkState) {
            this.state = nextState;
            result = true;
        }
        LOGGER.trace("ifNotThen state [%s] checkState [%s] nextState [%s] result (%b) new state [%s]", currentState, checkState, nextState, result, this.state);
        return result;
    }

    public void ifTrueThenElse(boolean value, T trueState, T falseState) {
        this.state = value ? trueState : falseState;
        LOGGER.trace("ifTrueThenElse value [%b] trueState [%s] falseState [%s] next state [%s]", value, trueState, falseState, this.state);
    }

    public String toString() {
        return ((Enum)this.state).toString();
    }
}

