/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public class LockAnnotationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockAnnotationUtils.class);
    private static final LockAnnotationUtils SINGLETON = new LockAnnotationUtils();
    private final Map<String, ReentrantReadWriteLock> LOCK_MAP = new ConcurrentHashMap<String, ReentrantReadWriteLock>();

    private LockAnnotationUtils() {
    }

    public static LockAnnotationUtils singleton() {
        return SINGLETON;
    }

    public void processLockAnnotations(Method method) {
        Annotation[] annotations;
        if (!(method.isAnnotationPresent(TestEngine.Lock.class) || method.isAnnotationPresent(TestEngine.Lock.List.class) || method.isAnnotationPresent(TestEngine.ResourceLock.class) || method.isAnnotationPresent(TestEngine.ResourceLock.List.class))) {
            return;
        }
        for (Annotation annotation : annotations = method.getAnnotations()) {
            TestEngine.Lock.List lockListAnnotation;
            TestEngine.Lock lockAnnotation;
            if (annotation.annotationType().isAssignableFrom(TestEngine.Lock.class)) {
                lockAnnotation = (TestEngine.Lock)annotation;
                this.lock(method, lockAnnotation.name(), lockAnnotation.mode());
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.Lock.List.class)) {
                lockListAnnotation = (TestEngine.Lock.List)annotation;
                Stream.of(lockListAnnotation.value()).forEach(lock -> this.lock(method, lock.name(), lock.mode()));
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.class)) {
                lockAnnotation = (TestEngine.ResourceLock)annotation;
                this.lock(method, lockAnnotation.name(), lockAnnotation.mode());
                continue;
            }
            if (!annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.List.class)) continue;
            lockListAnnotation = (TestEngine.ResourceLock.List)annotation;
            Stream.of(lockListAnnotation.value()).forEach(lock -> this.lock(method, lock.name(), lock.mode()));
        }
    }

    private void lock(Method method, String name, TestEngine.LockMode mode) {
        if (name != null && !name.trim().isEmpty()) {
            String trimmedName = name.trim();
            LOGGER.trace(String.format("Acquiring lock [%s] mode [%s] class [%s] method [%s]", trimmedName, mode, method.getDeclaringClass().getName(), method.getName()));
            if (mode == TestEngine.LockMode.READ_WRITE) {
                this.LOCK_MAP.computeIfAbsent(trimmedName, n -> this.createLock((String)n, true)).writeLock().lock();
            } else {
                this.LOCK_MAP.computeIfAbsent(trimmedName, n -> this.createLock((String)n, true)).readLock().lock();
            }
            LOGGER.trace(String.format("Acquired lock [%s] mode [%s] class [%s] method [%s]", trimmedName, mode, method.getDeclaringClass().getName(), method.getName()));
        }
    }

    public void processUnlockAnnotations(Method method) {
        Annotation[] annotations;
        if (!(method.isAnnotationPresent(TestEngine.Unlock.class) || method.isAnnotationPresent(TestEngine.Unlock.List.class) || method.isAnnotationPresent(TestEngine.ResourceLock.class) || method.isAnnotationPresent(TestEngine.ResourceLock.List.class))) {
            return;
        }
        for (Annotation annotation : annotations = method.getAnnotations()) {
            TestEngine.Unlock.List unlockListAnnotation;
            TestEngine.Unlock unlockAnnotation;
            if (annotation.annotationType().isAssignableFrom(TestEngine.Unlock.class)) {
                unlockAnnotation = (TestEngine.Unlock)annotation;
                this.unlock(method, unlockAnnotation.name(), unlockAnnotation.mode());
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.Unlock.List.class)) {
                unlockListAnnotation = (TestEngine.Unlock.List)annotation;
                Stream.of(unlockListAnnotation.value()).forEach(lock -> this.unlock(method, lock.name(), lock.mode()));
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.class)) {
                unlockAnnotation = (TestEngine.ResourceLock)annotation;
                this.unlock(method, unlockAnnotation.name(), unlockAnnotation.mode());
                continue;
            }
            if (!annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.List.class)) continue;
            unlockListAnnotation = (TestEngine.ResourceLock.List)annotation;
            List<TestEngine.ResourceLock> list = Arrays.asList(unlockListAnnotation.value());
            Collections.reverse(list);
            list.forEach(lock -> this.unlock(method, lock.name(), lock.mode()));
        }
    }

    private void unlock(Method method, String name, TestEngine.LockMode mode) {
        if (name != null && !name.trim().isEmpty()) {
            ReentrantReadWriteLock reentrantReadWriteLock = this.LOCK_MAP.get(name);
            if (reentrantReadWriteLock != null) {
                LOGGER.trace(String.format("Releasing lock [%s] mode [%s] class [%s] method [%s]", name.trim(), mode, method.getDeclaringClass().getName(), method.getName()));
                if (mode == TestEngine.LockMode.READ_WRITE) {
                    reentrantReadWriteLock.writeLock().unlock();
                } else {
                    reentrantReadWriteLock.readLock().unlock();
                }
                LOGGER.trace(String.format("Released lock [%s] mode [%s] class [%s] method [%s]", name.trim(), mode, method.getDeclaringClass().getName(), method.getName()));
            } else {
                throw new TestClassConfigurationException(String.format("@TestEngine.Unlock without @TestEngine.Lock, name [%s] mode [%s] class [%s] method [%s]", name.trim(), mode, method.getDeclaringClass().getName(), method.getName()));
            }
        }
    }

    private ReentrantReadWriteLock createLock(String name, boolean fair) {
        LOGGER.trace("createLock name [%s] fair [%b]", name, fair);
        return new ReentrantReadWriteLock(fair);
    }
}

