/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.TestClassConfigurationException;
import org.antublue.test.engine.internal.TestEngineException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.commons.support.ReflectionSupport;

public final class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Class<?>[] NO_CLASS_ARGS = null;
    private static final Object[] NO_OBJECT_ARGS = null;
    private static final ReflectionUtils SINGLETON = new ReflectionUtils();
    private final Map<Class<?>, Method> ARGUMENT_SUPPLIER_METHOD_CACHE = new HashMap();
    private final Map<Class<?>, Optional<Field>> ARGUMENT_FIELD_CACHE = new HashMap();
    private final Map<Class<?>, List<Field>> AUTO_CLOSE_FIELD_CACHE = new HashMap();
    private final Map<Class<?>, List<Method>> PREPARE_METHOD_CACHE = new HashMap();
    private final Map<Class<?>, List<Method>> BEFORE_ALL_METHOD_CACHE = new HashMap();
    private final Map<Class<?>, List<Method>> BEFORE_EACH_METHOD_CACHE = new HashMap();
    private final Map<Class<?>, List<Method>> TEST_METHOD_CACHE = new HashMap();
    private final Map<Class<?>, List<Method>> AFTER_EACH_METHOD_CACHE = new HashMap();
    private final Map<Class<?>, List<Method>> AFTER_ALL_METHOD_CACHE = new HashMap();
    private final Map<Class<?>, List<Method>> CONCLUDE_METHOD_CACHE = new HashMap();

    private ReflectionUtils() {
    }

    public static ReflectionUtils singleton() {
        return SINGLETON;
    }

    public List<Class<?>> findAllClasses(URI uri) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("findAllClasses uri [%s]", (Object)uri.toASCIIString());
        }
        ArrayList classes = org.junit.platform.commons.util.ReflectionUtils.findAllClassesInClasspathRoot((URI)uri, classFilter -> true, classNameFilter -> true);
        classes = new ArrayList(classes);
        this.sortClasses(classes);
        this.validateDistinctOrder(classes);
        return classes;
    }

    public List<Class<?>> findAllClasses(String packageName) {
        LOGGER.trace("findAllClasses package name [%s]", (Object)packageName);
        ArrayList classes = ReflectionSupport.findAllClassesInPackage((String)packageName, classFilter -> true, classNameFilter -> true);
        classes = new ArrayList(classes);
        this.sortClasses(classes);
        this.validateDistinctOrder(classes);
        return classes;
    }

    public boolean acceptsArgument(Method method, Argument argument) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1 && parameterTypes[0].isAssignableFrom(argument.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getArgumentSupplierMethod(Class<?> clazz) {
        Map<Class<?>, Method> map = this.ARGUMENT_SUPPLIER_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getArgumentSupplierMethod class [%s]", (Object)clazz.getName());
            if (this.ARGUMENT_SUPPLIER_METHOD_CACHE.containsKey(clazz)) {
                return this.ARGUMENT_SUPPLIER_METHOD_CACHE.get(clazz);
            }
            List<Method> methodList = this.getMethodsSubclassFirst(clazz, TestEngine.ArgumentSupplier.class, Scope.STATIC, Stream.class, NO_CLASS_ARGS);
            if (methodList.isEmpty()) {
                methodList = this.getMethodsSuperclassFirst(clazz, TestEngine.ArgumentSupplier.class, Scope.STATIC, Iterable.class, NO_CLASS_ARGS);
            }
            LOGGER.trace("@TestEngine.ArgumentSupplier class [%s] method count [%d]", clazz.getName(), methodList.size());
            if (methodList.size() != 1) {
                throw new TestClassConfigurationException(String.format("Test class [%s] must define exactly 1 @TestEngine.ArgumentSupplier method, %d methods were found", clazz.getName(), methodList.size()));
            }
            Method method = methodList.get(0);
            this.ARGUMENT_SUPPLIER_METHOD_CACHE.put(clazz, method);
            return method;
        }
    }

    public List<Argument> getArgumentsList(Class<?> clazz) {
        LOGGER.trace("getArgumentsList class [%s]", (Object)clazz.getName());
        try {
            Method method = this.getArgumentSupplierMethod(clazz);
            Object object = method.invoke(null, NO_OBJECT_ARGS);
            if (object instanceof Stream) {
                List<Argument> arguments = ((Stream)object).collect(Collectors.toList());
                LOGGER.trace("class [%s] argument count [%d]", clazz.getName(), arguments.size());
                return arguments;
            }
            if (object instanceof Iterable) {
                ArrayList<Argument> arguments = new ArrayList<Argument>();
                ((Iterable)object).forEach(arguments::add);
                LOGGER.trace("class [%s] argument count [%d]", clazz.getName(), arguments.size());
                return arguments;
            }
            throw new TestClassConfigurationException(String.format("Test class [%s] must define one @TestEngine.ArgumentSupplier method", clazz.getName()));
        }
        catch (TestClassConfigurationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new TestClassConfigurationException(String.format("Can't get Stream<Argument> or Iterable<Argument> from test class [%s]", clazz.getName()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Method> getPrepareMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = this.PREPARE_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getPrepareMethods class [%s]", (Object)clazz.getName());
            if (this.PREPARE_METHOD_CACHE.containsKey(clazz)) {
                return this.PREPARE_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = this.getMethodsSuperclassFirst(clazz, TestEngine.Prepare.class, Scope.NON_STATIC, Void.class, NO_CLASS_ARGS).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList());
            LOGGER.trace("@TestEngine.Prepare class [%s] method count [%d]", clazz.getName(), methods.size());
            methods = Collections.unmodifiableList(methods);
            this.PREPARE_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Field> getArgumentField(Class<?> clazz) {
        Map<Class<?>, Optional<Field>> map = this.ARGUMENT_FIELD_CACHE;
        synchronized (map) {
            Optional<Field> optionalField;
            LOGGER.trace("getArgumentField class [%s]", (Object)clazz.getName());
            if (this.ARGUMENT_FIELD_CACHE.containsKey(clazz)) {
                return this.ARGUMENT_FIELD_CACHE.get(clazz);
            }
            List<Field> argumentFields = this.getFields(clazz, TestEngine.Argument.class, Argument.class);
            LOGGER.trace("@TestEngine.Argument class [%s] field count [%d]", clazz.getName(), argumentFields.size());
            if (argumentFields.isEmpty()) {
                optionalField = Optional.empty();
                this.ARGUMENT_FIELD_CACHE.put(clazz, optionalField);
            } else {
                Field field = argumentFields.get(0);
                optionalField = Optional.of(field);
                this.ARGUMENT_FIELD_CACHE.put(clazz, optionalField);
            }
            return optionalField;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Field> getAutoCloseFields(Class<?> clazz) {
        Map<Class<?>, List<Field>> map = this.AUTO_CLOSE_FIELD_CACHE;
        synchronized (map) {
            LOGGER.trace("getAutoCloseFields class [%s]", (Object)clazz.getName());
            if (this.AUTO_CLOSE_FIELD_CACHE.containsKey(clazz)) {
                return this.AUTO_CLOSE_FIELD_CACHE.get(clazz);
            }
            List<Field> autoCloseFields = this.getFields(clazz, TestEngine.AutoClose.class, Object.class);
            LOGGER.trace("@TestEngine.AutoClose class [%s] field count [%d]", clazz.getName(), autoCloseFields.size());
            this.AUTO_CLOSE_FIELD_CACHE.put(clazz, autoCloseFields);
            return autoCloseFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Method> getBeforeAllMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = this.BEFORE_ALL_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getBeforeAllMethods class [%s]", (Object)clazz.getName());
            if (this.BEFORE_ALL_METHOD_CACHE.containsKey(clazz)) {
                return this.BEFORE_ALL_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = this.getMethodsSuperclassFirst(clazz, TestEngine.BeforeAll.class, Scope.NON_STATIC, Void.class, NO_CLASS_ARGS).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList());
            methods.addAll(this.getMethodsSuperclassFirst(clazz, TestEngine.BeforeAll.class, Scope.NON_STATIC, Void.class, Argument.class).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList()));
            LOGGER.trace("@TestEngine.BeforeAll class [%s] method count [%d]", clazz.getName(), methods.size());
            methods = Collections.unmodifiableList(methods);
            this.BEFORE_ALL_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Method> getBeforeEachMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = this.BEFORE_EACH_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getBeforeEachMethods class [%s]", (Object)clazz.getName());
            if (this.BEFORE_EACH_METHOD_CACHE.containsKey(clazz)) {
                return this.BEFORE_EACH_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = this.getMethodsSuperclassFirst(clazz, TestEngine.BeforeEach.class, Scope.NON_STATIC, Void.class, NO_CLASS_ARGS).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList());
            methods.addAll(this.getMethodsSuperclassFirst(clazz, TestEngine.BeforeEach.class, Scope.NON_STATIC, Void.class, Argument.class).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList()));
            LOGGER.trace("@TestEngine.BeforeEach class [%s] method count [%d]", clazz.getName(), methods.size());
            methods = Collections.unmodifiableList(methods);
            this.BEFORE_EACH_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Method> getTestMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = this.TEST_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getTestMethods class [%s]", (Object)clazz.getName());
            if (this.TEST_METHOD_CACHE.containsKey(clazz)) {
                return new ArrayList<Method>((Collection)this.TEST_METHOD_CACHE.get(clazz));
            }
            List methods = this.getMethodsSuperclassFirst(clazz, TestEngine.Test.class, Scope.NON_STATIC, Void.class, NO_CLASS_ARGS).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList());
            methods.addAll(this.getMethodsSuperclassFirst(clazz, TestEngine.Test.class, Scope.NON_STATIC, Void.class, Argument.class).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList()));
            LOGGER.trace("@TestEngine.Test class [%s] method count [%d]", clazz.getName(), methods.size());
            methods = Collections.unmodifiableList(methods);
            this.TEST_METHOD_CACHE.put(clazz, methods);
            return new ArrayList<Method>(methods);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Method> getAfterEachMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = this.AFTER_EACH_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getAfterEachMethods class [%s]", (Object)clazz.getName());
            if (this.AFTER_EACH_METHOD_CACHE.containsKey(clazz)) {
                return this.AFTER_EACH_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = this.getMethodsSubclassFirst(clazz, TestEngine.AfterEach.class, Scope.NON_STATIC, Void.class, NO_CLASS_ARGS).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList());
            methods.addAll(this.getMethodsSubclassFirst(clazz, TestEngine.AfterEach.class, Scope.NON_STATIC, Void.class, Argument.class).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList()));
            LOGGER.trace("@TestEngine.AfterEach class [%s] method count [%d]", clazz.getName(), methods.size());
            methods = Collections.unmodifiableList(methods);
            this.AFTER_EACH_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Method> getAfterAllMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = this.AFTER_ALL_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getAfterAllMethods class [%s]", (Object)clazz.getName());
            if (this.AFTER_ALL_METHOD_CACHE.containsKey(clazz)) {
                return this.AFTER_ALL_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = this.getMethodsSubclassFirst(clazz, TestEngine.AfterAll.class, Scope.NON_STATIC, Void.class, NO_CLASS_ARGS).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList());
            methods.addAll(this.getMethodsSubclassFirst(clazz, TestEngine.AfterAll.class, Scope.NON_STATIC, Void.class, Argument.class).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList()));
            LOGGER.trace("@TestEngine.AfterAll class [%s] method count [%d]", clazz.getName(), methods.size());
            methods = Collections.unmodifiableList(methods);
            this.AFTER_ALL_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Method> getConcludeMethods(Class<?> clazz) {
        Map<Class<?>, List<Method>> map = this.CONCLUDE_METHOD_CACHE;
        synchronized (map) {
            LOGGER.trace("getConcludeMethods class [%s]", (Object)clazz.getName());
            if (this.CONCLUDE_METHOD_CACHE.containsKey(clazz)) {
                return this.CONCLUDE_METHOD_CACHE.get(clazz);
            }
            List<Method> methods = this.getMethodsSubclassFirst(clazz, TestEngine.Conclude.class, Scope.NON_STATIC, Void.class, NO_CLASS_ARGS).stream().filter(method -> !method.isAnnotationPresent(TestEngine.Disabled.class)).collect(Collectors.toList());
            LOGGER.trace("@TestEngine.Conclude class [%s] method count [%d]", clazz.getName(), methods.size());
            methods = Collections.unmodifiableList(methods);
            this.CONCLUDE_METHOD_CACHE.put(clazz, methods);
            return methods;
        }
    }

    public String getDisplayName(Method method) {
        String name;
        String displayName = method.getName();
        TestEngine.DisplayName annotation = method.getAnnotation(TestEngine.DisplayName.class);
        if (annotation != null && (name = annotation.name()) != null && !name.trim().isEmpty()) {
            displayName = name.trim();
        }
        LOGGER.trace("getDisplayName method [%s] display name [%s]", method.getName(), displayName);
        return displayName;
    }

    public String getDisplayName(Class<?> clazz) {
        String name;
        String displayName = clazz.getName();
        TestEngine.DisplayName annotation = clazz.getAnnotation(TestEngine.DisplayName.class);
        if (annotation != null && (name = annotation.name()) != null && !name.trim().isEmpty()) {
            displayName = name.trim();
        }
        LOGGER.trace("getDisplayName class [%s] display name [%s]", clazz.getName(), displayName);
        return displayName;
    }

    private List<Field> getFields(Class<?> clazz, Class<? extends Annotation> annotation, Class<?> fieldType) {
        LOGGER.trace("getFields class [%s] annotation [%s] fieldType [%s]", clazz.getName(), annotation.getName(), fieldType.getName());
        LinkedHashSet<Field> fieldSet = new LinkedHashSet<Field>();
        this.resolveFields(clazz, annotation, fieldType, fieldSet);
        ArrayList<Field> fields = new ArrayList<Field>(fieldSet);
        fields.sort(Comparator.comparing(Field::getName));
        LOGGER.trace("class [%s] argument field count [%d]", clazz.getName(), fieldSet.size());
        return fields;
    }

    private void resolveFields(Class<?> clazz, Class<? extends Annotation> annotation, Class<?> fieldType, Set<Field> fieldSet) {
        LOGGER.trace("resolveFields class [%s] annotation [%s] fieldType [%s]", clazz.getName(), annotation.getName(), fieldType.getName());
        List fields = Stream.of(clazz.getDeclaredFields()).filter(field -> {
            int modifiers = field.getModifiers();
            return !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && field.isAnnotationPresent(annotation) && fieldType.isAssignableFrom(field.getType());
        }).collect(Collectors.toList());
        for (Field field2 : fields) {
            field2.setAccessible(true);
            fieldSet.add(field2);
        }
        Class<?> declaringClass = clazz.getSuperclass();
        if (declaringClass != null && !declaringClass.equals(Object.class)) {
            this.resolveFields(declaringClass, annotation, fieldType, fieldSet);
        }
    }

    private List<Method> getMethodsSuperclassFirst(Class<?> clazz, Class<? extends Annotation> annotation, Scope scope, Class<?> returnType, Class<?> ... parameterTypes) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getMethodsSuperclassFirst annotation [%s] class [%s] parameterTypes [%s] returnType [%s]", annotation.getName(), clazz.getName(), this.toString(parameterTypes), returnType.getName());
        }
        LinkedHashSet classes = new LinkedHashSet();
        this.buildClassSetSuperclassFirst(clazz, classes);
        LinkedHashMap<String, Method> methods = new LinkedHashMap<String, Method>();
        for (Class clazz2 : classes) {
            this.resolveMethodsSuperclassFirst(clazz2, annotation, scope, returnType, parameterTypes, methods);
        }
        return new ArrayList<Method>(methods.values());
    }

    private void buildClassSetSuperclassFirst(Class<?> clazz, Set<Class<?>> classes) {
        LOGGER.trace("buildClassSetSuperclassFirst class [%s]", (Object)clazz.getName());
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            this.buildClassSetSuperclassFirst(superclass, classes);
        }
        classes.add(clazz);
    }

    private List<Method> getMethodsSubclassFirst(Class<?> clazz, Class<? extends Annotation> annotation, Scope scope, Class<?> returnType, Class<?> ... parameterTypes) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getMethodsSubclassFirst annotation [%s] class [%s] parameterTypes [%s] returnType [%s]", annotation.getName(), clazz.getName(), this.toString(parameterTypes), returnType.getName());
        }
        LinkedHashSet classes = new LinkedHashSet();
        this.buildClassSetSubclassFirst(clazz, classes);
        LinkedHashMap<String, Method> methods = new LinkedHashMap<String, Method>();
        for (Class clazz2 : classes) {
            this.resolveMethodsSuperclassFirst(clazz2, annotation, scope, returnType, parameterTypes, methods);
        }
        return new ArrayList<Method>(methods.values());
    }

    private void buildClassSetSubclassFirst(Class<?> clazz, Set<Class<?>> classes) {
        LOGGER.trace("buildClassSetSubclassFirst class [%s]", (Object)clazz.getName());
        classes.add(clazz);
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && !superclass.equals(Object.class)) {
            this.buildClassSetSuperclassFirst(superclass, classes);
        }
    }

    private void resolveMethodsSuperclassFirst(Class<?> clazz, Class<? extends Annotation> annotation, Scope scope, Class<?> returnType, Class<?>[] parameterTypes, Map<String, Method> methods) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("resolveMethodsSuperclassFirst annotation [%s] class [%s] parameterTypes [%s] returnType [%s]", annotation.getName(), clazz.getName(), this.toString(parameterTypes), returnType.getName());
        }
        try {
            List<Method> methodList = Stream.of(clazz.getDeclaredMethods()).filter(method -> method.isAnnotationPresent(annotation)).filter(method -> {
                int modifiers = method.getModifiers();
                return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
            }).filter(method -> {
                int modifiers = method.getModifiers();
                if (scope == Scope.STATIC && !Modifier.isStatic(modifiers)) {
                    throw new TestClassConfigurationException(String.format("%s method [%s] must be declared static", this.getAnnotationDisplayName(annotation), method.getName()));
                }
                if (scope != Scope.STATIC && Modifier.isStatic(modifiers)) {
                    throw new TestClassConfigurationException(String.format("%s method [%s] must be not be declared static", this.getAnnotationDisplayName(annotation), method.getName()));
                }
                return true;
            }).filter(method -> {
                if (parameterTypes == null) {
                    return method.getParameterTypes().length == 0;
                }
                if (parameterTypes.length != method.getParameterCount()) {
                    return false;
                }
                Class<?>[] methodParameterTypes = method.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i].isAssignableFrom(methodParameterTypes[i])) continue;
                    return false;
                }
                return true;
            }).filter(method -> {
                if (returnType == Void.class) {
                    return method.getReturnType().getName().equals("void");
                }
                return returnType.isAssignableFrom(method.getReturnType());
            }).collect(Collectors.toList());
            for (Method method2 : methodList) {
                method2.setAccessible(true);
            }
            this.validateDistinctOrder(clazz, methodList);
            this.sortMethods(methodList);
            for (Method method2 : methodList) {
                methods.putIfAbsent(method2.getName(), method2);
            }
        }
        catch (NoClassDefFoundError methodList) {
        }
        catch (TestEngineException e) {
            throw e;
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
            System.out.flush();
            throw new TestEngineException(String.format("Exception resolving methods class [%s]", clazz.getName()), t);
        }
    }

    private void sortClasses(List<Class<?>> classes) {
        LOGGER.trace("sortClasses count [%s]", (Object)classes.size());
        classes.sort((o1, o2) -> {
            int o1Order = Integer.MAX_VALUE;
            TestEngine.Order o1Annotation = o1.getAnnotation(TestEngine.Order.class);
            if (o1Annotation != null) {
                o1Order = o1Annotation.order();
            }
            int o2Order = Integer.MAX_VALUE;
            TestEngine.Order o2Annotation = o2.getAnnotation(TestEngine.Order.class);
            if (o2Annotation != null) {
                o2Order = o2Annotation.order();
            }
            if (o1Order != o2Order) {
                return Integer.compare(o1Order, o2Order);
            }
            String o1DisplayName = this.getDisplayName((Class<?>)o1);
            String o2DisplayName = this.getDisplayName((Class<?>)o2);
            return o1DisplayName.compareTo(o2DisplayName);
        });
    }

    private void validateDistinctOrder(List<Class<?>> classes) {
        LOGGER.trace("validateDistinctOrder count [%s]", (Object)classes.size());
        LinkedHashMap orderToClassMap = new LinkedHashMap();
        for (Class<?> clazz : classes) {
            if (clazz.isAnnotationPresent(TestEngine.BaseClass.class) || Modifier.isAbstract(clazz.getModifiers()) || !clazz.isAnnotationPresent(TestEngine.Order.class)) continue;
            int order = clazz.getAnnotation(TestEngine.Order.class).order();
            LOGGER.trace("clazz [%s] order [%d]", clazz.getName(), order);
            if (orderToClassMap.containsKey(order)) {
                Class existingClass = (Class)orderToClassMap.get(order);
                throw new TestClassConfigurationException(String.format("Test class [%s] (or superclass) and test class [%s] (or superclass) contain duplicate @TestEngine.Order(%d) class annotation", existingClass.getName(), clazz.getName(), order));
            }
            orderToClassMap.put(order, clazz);
        }
    }

    private void sortMethods(List<Method> methods) {
        LOGGER.trace("sortMethods count [%s]", (Object)methods.size());
        methods.sort((o1, o2) -> {
            int o1Order = Integer.MAX_VALUE;
            TestEngine.Order o1Annotation = o1.getAnnotation(TestEngine.Order.class);
            if (o1Annotation != null) {
                o1Order = o1Annotation.order();
            }
            int o2Order = Integer.MAX_VALUE;
            TestEngine.Order o2Annotation = o2.getAnnotation(TestEngine.Order.class);
            if (o2Annotation != null) {
                o2Order = o2Annotation.order();
            }
            if (o1Order != o2Order) {
                return Integer.compare(o1Order, o2Order);
            }
            String o1DisplayName = this.getDisplayName((Method)o1);
            String o2DisplayName = this.getDisplayName((Method)o2);
            return o1DisplayName.compareTo(o2DisplayName);
        });
    }

    private void validateDistinctOrder(Class<?> clazz, List<Method> methods) {
        LOGGER.trace("validateDistinctOrder class [%s] count [%s]", clazz.getName(), methods.size());
        HashSet<Integer> integers = new HashSet<Integer>();
        for (Method method : methods) {
            TestEngine.Order annotation = method.getAnnotation(TestEngine.Order.class);
            if (annotation == null) continue;
            int value = annotation.order();
            if (integers.contains(value)) {
                throw new TestClassConfigurationException(String.format("Test class [%s] (or superclass) contains a duplicate @TestEngine.Order(%d) method annotation", clazz.getName(), value));
            }
            integers.add(value);
        }
    }

    private String getAnnotationDisplayName(Class<? extends Annotation> annotation) {
        String displayName = String.format("@%s.%s", annotation.getDeclaringClass().getSimpleName(), annotation.getSimpleName());
        LOGGER.trace("getAnnotationDisplayName annotation [%s] display name [%s]", annotation.getName(), displayName);
        return displayName;
    }

    private String toString(Class<?>[] parameterTypes) {
        StringBuilder stringBuilder = new StringBuilder();
        if (parameterTypes != null) {
            stringBuilder.append("[");
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(parameterTypes[i].getName());
            }
            stringBuilder.append("]");
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }

    private static enum Scope {
        STATIC,
        NON_STATIC;

    }
}

