/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.AutoCloseAnnotationUtils;
import org.antublue.test.engine.internal.ExecutorContext;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.statemachine.StateMachine;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class ArgumentTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument testArgument;
    private final List<Throwable> throwables;
    private final StateMachine<State> stateMachine;
    private ExecutorContext executorContext;
    private Object testInstance;

    ArgumentTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Argument testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
        this.throwables = new ArrayList<Throwable>();
        this.stateMachine = new StateMachine<State>(((Object)((Object)this)).getClass().getName()).addTransition(State.BEGIN, this::begin).addTransition(State.PRE_BEFORE_ALL, this::preBeforeAll).addTransition(State.BEFORE_ALL, this::beforeAll).addTransition(State.POST_BEFORE_ALL, this::postBeforeAll).addTransition(State.EXECUTE, this::execute).addTransition(State.SKIP, this::skip).addTransition(State.SKIP2, this::skip2).addTransition(State.PRE_AFTER_ALL, this::preAfterAll).addTransition(State.AFTER_ALL, this::afterAll).addTransition(State.POST_AFTER_ALL, this::postAfterAll).addTransition(State.END, this::end);
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)REFLECTION_UTILS.getArgumentSupplierMethod(this.testClass)));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    @Override
    public void execute(ExecutorContext executorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        this.executorContext = executorContext;
        try {
            this.stateMachine.run(State.BEGIN);
        }
        catch (Throwable t) {
            this.printStackTrace(System.out, t);
            System.out.flush();
        }
    }

    private void begin(StateMachine<State> stateMachine) {
        LOGGER.trace("begin uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        try {
            this.executorContext.getExecutionRequest().getEngineExecutionListener().executionStarted((TestDescriptor)this);
            this.testInstance = this.executorContext.getTestInstance();
            Optional<Field> optionalField = REFLECTION_UTILS.getArgumentField(this.testClass);
            if (optionalField.isPresent()) {
                LOGGER.trace("injecting test argument");
                optionalField.get().set(this.testInstance, this.testArgument);
            }
            stateMachine.signal(State.PRE_BEFORE_ALL);
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
            stateMachine.signal(State.SKIP);
        }
        finally {
            System.out.flush();
        }
    }

    private void preBeforeAll(StateMachine<State> stateMachine) {
        LOGGER.trace("preBeforeAll uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        stateMachine.signal(State.BEFORE_ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeAll(StateMachine<State> stateMachine) {
        LOGGER.trace("beforeAll uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        try {
            List<Method> methods = REFLECTION_UTILS.getBeforeAllMethods(this.testClass);
            for (Method method : methods) {
                try {
                    LOCK_ANNOTATION_UTILS.processLockAnnotations(method);
                    if (REFLECTION_UTILS.acceptsArgument(method, this.testArgument)) {
                        method.invoke(this.testInstance, this.testArgument);
                        continue;
                    }
                    method.invoke(this.testInstance, NO_OBJECT_ARGS);
                }
                finally {
                    LOCK_ANNOTATION_UTILS.processUnlockAnnotations(method);
                    System.out.flush();
                }
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.POST_BEFORE_ALL);
            System.out.flush();
        }
    }

    private void postBeforeAll(StateMachine<State> stateMachine) {
        LOGGER.trace("postBeforeAll uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        if (this.throwables.isEmpty()) {
            stateMachine.signal(State.EXECUTE);
        } else {
            stateMachine.signal(State.SKIP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(StateMachine<State> stateMachine) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        try {
            List methodTestDescriptors = this.getChildren(MethodTestDescriptor.class);
            for (MethodTestDescriptor methodTestDescriptor : methodTestDescriptors) {
                methodTestDescriptor.execute(this.executorContext);
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.PRE_AFTER_ALL);
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skip(StateMachine<State> stateMachine) {
        LOGGER.trace("skip uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        try {
            List methodTestDescriptors = this.getChildren(MethodTestDescriptor.class);
            for (MethodTestDescriptor methodTestDescriptor : methodTestDescriptors) {
                methodTestDescriptor.skip(this.executorContext);
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.PRE_AFTER_ALL);
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skip2(StateMachine<State> stateMachine) {
        LOGGER.trace("skip2 uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        try {
            List methodTestDescriptors = this.getChildren(MethodTestDescriptor.class);
            for (MethodTestDescriptor methodTestDescriptor : methodTestDescriptors) {
                methodTestDescriptor.skip(this.executorContext);
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.END);
            System.out.flush();
        }
    }

    private void preAfterAll(StateMachine<State> stateMachine) {
        LOGGER.trace("preAfterAll uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        stateMachine.signal(State.AFTER_ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterAll(StateMachine<State> stateMachine) {
        LOGGER.trace("afterAll uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        try {
            List<Method> methods = REFLECTION_UTILS.getAfterAllMethods(this.testClass);
            for (Method method : methods) {
                try {
                    LOCK_ANNOTATION_UTILS.processLockAnnotations(method);
                    if (REFLECTION_UTILS.acceptsArgument(method, this.testArgument)) {
                        method.invoke(this.testInstance, this.testArgument);
                        continue;
                    }
                    method.invoke(this.testInstance, NO_OBJECT_ARGS);
                }
                catch (Throwable t) {
                    this.throwables.add(t);
                    this.printStackTrace(System.out, t);
                }
                finally {
                    LOCK_ANNOTATION_UTILS.processUnlockAnnotations(method);
                    System.out.flush();
                }
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.POST_AFTER_ALL);
            System.out.flush();
        }
    }

    private void postAfterAll(StateMachine<State> stateMachine) {
        LOGGER.trace("postAfterAll uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        stateMachine.signal(State.END);
    }

    private void end(StateMachine<State> stateMachine) {
        LOGGER.trace("end uniqueId [%s] testClass [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name());
        try {
            Optional<Field> optionalField = REFLECTION_UTILS.getArgumentField(this.testClass);
            if (optionalField.isPresent()) {
                LOGGER.trace("injecting test argument");
                optionalField.get().set(this.testInstance, null);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            AutoCloseAnnotationUtils.singleton().processAutoCloseAnnotatedFields(this.testInstance, "@TestEngine.AfterAll", this.throwables);
            if (this.throwables.isEmpty()) {
                this.executorContext.getExecutionRequest().getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
            } else {
                this.executorContext.getExecutionRequest().getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.throwables.get(0)));
            }
            stateMachine.stop();
            System.out.flush();
        }
    }

    private static enum State {
        BEGIN,
        PRE_BEFORE_ALL,
        BEFORE_ALL,
        POST_BEFORE_ALL,
        EXECUTE,
        SKIP,
        SKIP2,
        PRE_AFTER_ALL,
        AFTER_ALL,
        POST_AFTER_ALL,
        END;

    }
}

