/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.internal.AutoCloseAnnotationUtils;
import org.antublue.test.engine.internal.ExecutorContext;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.statemachine.StateMachine;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public final class ClassTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassTestDescriptor.class);
    private final Class<?> testClass;
    private final List<Throwable> throwables;
    private final StateMachine<State> stateMachine;
    private ExecutorContext executorContext;
    private Object testInstance;

    ClassTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.throwables = new ArrayList<Throwable>();
        this.stateMachine = new StateMachine<State>(((Object)((Object)this)).getClass().getName()).addTransition(State.BEGIN, this::begin).addTransition(State.PRE_PREPARE, this::prePrepare).addTransition(State.PREPARE, this::prepare).addTransition(State.POST_PREPARE, this::postPrepare).addTransition(State.EXECUTE, this::execute).addTransition(State.SKIP, this::skip).addTransition(State.SKIP2, this::skip2).addTransition(State.PRE_CONCLUDE, this::preConclude).addTransition(State.CONCLUDE, this::conclude).addTransition(State.POST_CONCLUDE, this::postConclude).addTransition(State.END, this::end);
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public boolean isTest() {
        return false;
    }

    public boolean isContainer() {
        return true;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public void execute(ExecutorContext executorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        this.executorContext = executorContext;
        try {
            this.stateMachine.run(State.BEGIN);
        }
        catch (Throwable t) {
            this.printStackTrace(System.out, t);
            System.out.flush();
        }
    }

    private void begin(StateMachine<State> stateMachine) {
        LOGGER.trace("begin uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        try {
            this.executorContext.getExecutionRequest().getEngineExecutionListener().executionStarted((TestDescriptor)this);
            this.testInstance = this.testClass.getDeclaredConstructor(NO_CLASS_ARGS).newInstance(NO_OBJECT_ARGS);
            this.executorContext.setTestInstance(this.testInstance);
            stateMachine.signal(State.PRE_PREPARE);
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
            stateMachine.signal(State.SKIP2);
        }
        finally {
            System.out.flush();
        }
    }

    private void prePrepare(StateMachine<State> stateMachine) {
        LOGGER.trace("prePrepare uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        stateMachine.signal(State.PREPARE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(StateMachine<State> stateMachine) {
        LOGGER.trace("prepare uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        try {
            List<Method> methods = REFLECTION_UTILS.getPrepareMethods(this.testClass);
            for (Method method : methods) {
                try {
                    LOCK_ANNOTATION_UTILS.processLockAnnotations(method);
                    method.invoke(this.testInstance, NO_OBJECT_ARGS);
                }
                finally {
                    LOCK_ANNOTATION_UTILS.processUnlockAnnotations(method);
                    System.out.flush();
                }
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.POST_PREPARE);
            System.out.flush();
        }
    }

    private void postPrepare(StateMachine<State> stateMachine) {
        LOGGER.trace("postPrepare uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        try {
            if (this.throwables.isEmpty()) {
                stateMachine.signal(State.EXECUTE);
            } else {
                stateMachine.signal(State.SKIP);
            }
        }
        finally {
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(StateMachine<State> stateMachine) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        try {
            List argumentTestDescriptors = this.getChildren(ArgumentTestDescriptor.class);
            for (ArgumentTestDescriptor argumentTestDescriptor : argumentTestDescriptors) {
                argumentTestDescriptor.execute(this.executorContext);
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.PRE_CONCLUDE);
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skip(StateMachine<State> stateMachine) {
        LOGGER.trace("skip uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        try {
            List argumentTestDescriptors = this.getChildren(ArgumentTestDescriptor.class);
            for (ArgumentTestDescriptor argumentTestDescriptor : argumentTestDescriptors) {
                argumentTestDescriptor.skip(this.executorContext);
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.PRE_CONCLUDE);
            System.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skip2(StateMachine<State> stateMachine) {
        LOGGER.trace("skip2 uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        try {
            List argumentTestDescriptors = this.getChildren(ArgumentTestDescriptor.class);
            for (ArgumentTestDescriptor argumentTestDescriptor : argumentTestDescriptors) {
                argumentTestDescriptor.skip(this.executorContext);
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.END);
            System.out.flush();
        }
    }

    private void preConclude(StateMachine<State> stateMachine) {
        LOGGER.trace("preConclude uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        stateMachine.signal(State.CONCLUDE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void conclude(StateMachine<State> stateMachine) {
        LOGGER.trace("conclude uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        try {
            List<Method> methods = REFLECTION_UTILS.getConcludeMethods(this.testClass);
            for (Method method : methods) {
                try {
                    LOCK_ANNOTATION_UTILS.processLockAnnotations(method);
                    method.invoke(this.testInstance, NO_OBJECT_ARGS);
                }
                catch (Throwable t) {
                    this.throwables.add(t);
                    this.printStackTrace(System.out, t);
                }
                finally {
                    LOCK_ANNOTATION_UTILS.processUnlockAnnotations(method);
                    System.out.flush();
                }
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.POST_CONCLUDE);
            System.out.flush();
        }
    }

    private void postConclude(StateMachine<State> stateMachine) {
        LOGGER.trace("postConclude uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        stateMachine.signal(State.END);
    }

    private void end(StateMachine<State> stateMachine) {
        LOGGER.trace("end uniqueId [%s] testClass [%s]", this.getUniqueId(), this.testClass.getName());
        AutoCloseAnnotationUtils.singleton().processAutoCloseAnnotatedFields(this.testInstance, "@TestEngine.Conclude", this.throwables);
        if (this.throwables.isEmpty()) {
            this.executorContext.getExecutionRequest().getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.executorContext.getExecutionRequest().getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.throwables.get(0)));
        }
        stateMachine.stop();
        this.executorContext.complete();
        System.out.flush();
    }

    private static enum State {
        BEGIN,
        PRE_PREPARE,
        PREPARE,
        POST_PREPARE,
        EXECUTE,
        SKIP,
        SKIP2,
        PRE_CONCLUDE,
        CONCLUDE,
        POST_CONCLUDE,
        END;

    }
}

