/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.descriptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.internal.AutoCloseAnnotationUtils;
import org.antublue.test.engine.internal.ExecutorContext;
import org.antublue.test.engine.internal.descriptor.ExtendedAbstractTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.statemachine.StateMachine;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public final class MethodTestDescriptor
extends ExtendedAbstractTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodTestDescriptor.class);
    private final Class<?> testClass;
    private final Argument testArgument;
    private final Method testMethod;
    private final List<Throwable> throwables;
    private final StateMachine<State> stateMachine;
    private ExecutorContext executorContext;
    private Object testInstance;

    MethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Method testMethod, Argument testArgument) {
        super(uniqueId, displayName);
        this.testClass = testClass;
        this.testArgument = testArgument;
        this.testMethod = testMethod;
        this.throwables = new ArrayList<Throwable>();
        this.stateMachine = new StateMachine<State>(((Object)((Object)this)).getClass().getName()).addTransition(State.BEGIN, this::begin).addTransition(State.PRE_BEFORE_EACH, this::preBeforeEach).addTransition(State.BEFORE_EACH, this::beforeEach).addTransition(State.POST_BEFORE_EACH, this::postBeforeEach).addTransition(State.PRE_TEST, this::preTest).addTransition(State.TEST, this::test).addTransition(State.POST_TEST, this::postTest).addTransition(State.PRE_AFTER_EACH, this::preAfterEach).addTransition(State.AFTER_EACH, this::afterEach).addTransition(State.POST_AFTER_EACH, this::postAfterEach).addTransition(State.END, this::end);
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public boolean isTest() {
        return true;
    }

    public boolean isContainer() {
        return false;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    @Override
    public void execute(ExecutorContext executorContext) {
        LOGGER.trace("execute uniqueId [%s] testClass [%s] testArgument [%s] testMethod [%s]", this.getUniqueId(), this.testClass.getName(), this.testArgument.name(), this.testMethod.getName());
        this.executorContext = executorContext;
        try {
            this.stateMachine.run(State.BEGIN);
        }
        catch (Throwable t) {
            this.printStackTrace(System.out, t);
            System.out.flush();
        }
    }

    private void begin(StateMachine<State> stateMachine) {
        LOGGER.trace("begin uniqueId [%s] testClass [%s] testMethod [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName(), this.testArgument.name());
        try {
            this.executorContext.getExecutionRequest().getEngineExecutionListener().executionStarted((TestDescriptor)this);
            this.testInstance = this.executorContext.getTestInstance();
            stateMachine.signal(State.PRE_BEFORE_EACH);
        }
        finally {
            System.out.flush();
        }
    }

    private void preBeforeEach(StateMachine<State> stateMachine) {
        LOGGER.trace("preBeforeEach uniqueId [%s] testClass [%s] testMethod [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName(), this.testArgument.name());
        stateMachine.signal(State.BEFORE_EACH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeEach(StateMachine<State> stateMachine) {
        LOGGER.trace("beforeEach uniqueId [%s] testClass [%s] testMethod [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName(), this.testArgument.name());
        try {
            List<Method> methods = REFLECTION_UTILS.getBeforeEachMethods(this.testClass);
            for (Method method : methods) {
                try {
                    LOCK_ANNOTATION_UTILS.processLockAnnotations(method);
                    if (REFLECTION_UTILS.acceptsArgument(method, this.testArgument)) {
                        method.invoke(this.testInstance, this.testArgument);
                        continue;
                    }
                    method.invoke(this.testInstance, NO_OBJECT_ARGS);
                }
                finally {
                    LOCK_ANNOTATION_UTILS.processUnlockAnnotations(method);
                    System.out.flush();
                }
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.POST_BEFORE_EACH);
            System.out.flush();
        }
    }

    private void postBeforeEach(StateMachine<State> stateMachine) {
        LOGGER.trace("postBeforeEach uniqueId [%s] testClass [%s] testMethod [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName(), this.testArgument.name());
        if (this.throwables.isEmpty()) {
            stateMachine.signal(State.PRE_TEST);
        } else {
            stateMachine.signal(State.PRE_AFTER_EACH);
        }
    }

    private void preTest(StateMachine<State> stateMachine) {
        LOGGER.trace("preTest uniqueId [%s] testClass [%s] testMethod [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName(), this.testArgument.name());
        stateMachine.signal(State.TEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(StateMachine<State> stateMachine) {
        LOGGER.trace("test uniqueId [%s] testClass [%s] testMethod [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName(), this.testArgument.name());
        try {
            Method method = this.testMethod;
            try {
                LOCK_ANNOTATION_UTILS.processLockAnnotations(method);
                if (REFLECTION_UTILS.acceptsArgument(method, this.testArgument)) {
                    method.invoke(this.testInstance, this.testArgument);
                } else {
                    method.invoke(this.testInstance, NO_OBJECT_ARGS);
                }
            }
            finally {
                LOCK_ANNOTATION_UTILS.processUnlockAnnotations(method);
                System.out.flush();
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.POST_TEST);
            System.out.flush();
        }
    }

    private void postTest(StateMachine<State> stateMachine) {
        LOGGER.trace("postTest uniqueId [%s] testClass [%s] testMethod [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName(), this.testArgument.name());
        stateMachine.signal(State.PRE_AFTER_EACH);
    }

    private void preAfterEach(StateMachine<State> stateMachine) {
        LOGGER.trace("preAfterEach uniqueId [%s] testClass [%s] testMethod [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName(), this.testArgument.name());
        stateMachine.signal(State.AFTER_EACH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterEach(StateMachine<State> stateMachine) {
        LOGGER.trace("afterEach uniqueId [%s] testClass [%s] testMethod [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName(), this.testArgument.name());
        try {
            List<Method> methods = REFLECTION_UTILS.getAfterEachMethods(this.testClass);
            for (Method method : methods) {
                try {
                    LOCK_ANNOTATION_UTILS.processLockAnnotations(method);
                    if (REFLECTION_UTILS.acceptsArgument(method, this.testArgument)) {
                        method.invoke(this.testInstance, this.testArgument);
                        continue;
                    }
                    method.invoke(this.testInstance, NO_OBJECT_ARGS);
                }
                catch (Throwable t) {
                    this.throwables.add(t);
                    this.printStackTrace(System.out, t);
                }
                finally {
                    LOCK_ANNOTATION_UTILS.processUnlockAnnotations(method);
                    System.out.flush();
                }
            }
        }
        catch (Throwable t) {
            this.throwables.add(t);
            this.printStackTrace(System.out, t);
        }
        finally {
            stateMachine.signal(State.POST_AFTER_EACH);
            System.out.flush();
        }
    }

    private void postAfterEach(StateMachine<State> stateMachine) {
        LOGGER.trace("postAfterEach uniqueId [%s] testClass [%s] testMethod [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName(), this.testArgument.name());
        stateMachine.signal(State.END);
    }

    private void end(StateMachine<State> stateMachine) {
        LOGGER.trace("end uniqueId [%s] testClass [%s] testMethod [%s] testArgument [%s]", this.getUniqueId(), this.testClass.getName(), this.testMethod.getName(), this.testArgument.name());
        AutoCloseAnnotationUtils.singleton().processAutoCloseAnnotatedFields(this.testInstance, "@TestEngine.AfterEach", this.throwables);
        if (this.throwables.isEmpty()) {
            this.executorContext.getExecutionRequest().getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.executorContext.getExecutionRequest().getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.throwables.get(0)));
        }
        stateMachine.stop();
        System.out.flush();
    }

    private static enum State {
        BEGIN,
        PRE_BEFORE_EACH,
        BEFORE_EACH,
        POST_BEFORE_EACH,
        PRE_TEST,
        TEST,
        POST_TEST,
        PRE_AFTER_EACH,
        AFTER_EACH,
        POST_AFTER_EACH,
        END;

    }
}

