/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.statemachine;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.antublue.test.engine.internal.statemachine.StateMachineException;
import org.antublue.test.engine.internal.statemachine.Transition;

public class StateMachine<S> {
    private final Map<S, Transition<S>> map = new HashMap<S, Transition<S>>();
    private final String id;
    private final AtomicReference<S> state;
    private final AtomicBoolean stop;
    private Throwable throwable;

    public StateMachine() {
        this(UUID.randomUUID().toString());
    }

    public StateMachine(String id) {
        this.id = id == null || id.trim().isEmpty() ? UUID.randomUUID().toString() : id.trim();
        this.state = new AtomicReference();
        this.stop = new AtomicBoolean();
    }

    public StateMachine<S> addTransition(S state, Transition<S> transition) {
        StateMachine.notNull(state, "state is null");
        StateMachine.notNull(transition, "transition is null");
        if (this.map.containsKey(state)) {
            throw new StateMachineException(String.format("transition already defined for state [%s]", state));
        }
        this.map.put(state, transition);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void signal(S state) {
        this.state.set(state);
    }

    public void run(S state) throws Throwable {
        if (!this.map.containsKey(state)) {
            throw new StateMachineException(String.format("no transition defined for state [%s]", state));
        }
        this.state.set(state);
        while (!this.stop.get()) {
            S nextState = this.state.get();
            if (nextState == null) {
                this.stop.set(true);
                break;
            }
            Transition<S> transition = this.map.get(nextState);
            if (transition == null) {
                throw new StateMachineException(String.format("no transition defined for state [%s]", nextState));
            }
            try {
                transition.execute(this);
            }
            catch (Throwable t) {
                throw new StateMachineException(String.format("unhandled exception in transition for state [%s]", this.getState()), t);
            }
        }
        if (this.throwable != null) {
            throw this.throwable;
        }
    }

    public void stop() {
        this.stop(null);
    }

    public void stop(Throwable throwable) {
        this.stop.set(true);
        this.throwable = throwable;
    }

    public S getState() {
        return this.state.get();
    }

    public String toString() {
        return this.state.toString();
    }

    private static void notNull(Object object, String message) {
        if (object == null) {
            throw new StateMachineException(message);
        }
    }
}

