/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.test.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.util.NamedThreadFactory;
import org.antublue.test.engine.internal.util.StandardStreams;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;

public class Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Executor.class);
    private static final int MAX_THREAD_COUNT = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute()");
        EngineExecutionListener engineExecutionListener = executionRequest.getEngineExecutionListener();
        TestDescriptor rootTestDescriptor = executionRequest.getRootTestDescriptor();
        ExecutorService executorService = null;
        AtomicReference<CountDownLatch> countDownLatch = new AtomicReference<CountDownLatch>();
        try {
            ConfigurationParameters configurationParameters = executionRequest.getConfigurationParameters();
            int threadCount = configurationParameters.get("antublue.test.engine.thread.count").map(value -> {
                try {
                    int intValue = Integer.parseInt(value);
                    if (intValue < 1) {
                        throw new TestEngineException(String.format("Invalid thread count [%d]", intValue));
                    }
                    return intValue;
                }
                catch (NumberFormatException e) {
                    throw new TestEngineException(String.format("Invalid thread count [%s]", value), e);
                }
            }).orElse(MAX_THREAD_COUNT);
            LOGGER.trace("[%s] = [%d]", "antublue.test.engine.thread.count", threadCount);
            executorService = new ThreadPoolExecutor(threadCount, threadCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(threadCount * 10), new NamedThreadFactory("test-engine-%02d"), new BlockingRejectedExecutionHandler());
            engineExecutionListener.executionStarted(executionRequest.getRootTestDescriptor());
            Set testDescriptors = rootTestDescriptor.getChildren();
            countDownLatch.set(new CountDownLatch(testDescriptors.size()));
            for (TestDescriptor testDescriptor : testDescriptors) {
                if (!(testDescriptor instanceof ExecutableTestDescriptor)) continue;
                ExecutableTestDescriptor executableTestDescriptor = (ExecutableTestDescriptor)testDescriptor;
                executorService.submit(() -> {
                    try {
                        executableTestDescriptor.execute(executionRequest);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        StandardStreams.flush();
                    }
                    finally {
                        ((CountDownLatch)countDownLatch.get()).countDown();
                    }
                });
            }
        }
        finally {
            if (countDownLatch.get() != null) {
                try {
                    ((CountDownLatch)countDownLatch.get()).await();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (executorService != null) {
                executorService.shutdown();
            }
        }
        engineExecutionListener.executionFinished(rootTestDescriptor, TestExecutionResult.successful());
    }

    private static class BlockingRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private BlockingRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            if (!executor.isShutdown()) {
                try {
                    executor.getQueue().put(runnable);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Runnable discarded!!!");
                }
            }
        }
    }
}

