/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.configuration;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;

public class Configuration {
    private static final Configuration SINGLETON = new Configuration();
    public static final String ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE = "ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_ENVIRONMENT_VARIABLE = "ANTUBLUE_TEST_ENGINE_PROPERTIES";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_SYSTEM_PROPERTY = "antublue.test.engine.properties";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME = ".antublue-test-engine.properties";
    private static final boolean TRACE = "true".equals(System.getenv("ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE"));
    private static final String USER_HOME = System.getProperty("user.home");
    private final Properties properties = new Properties();
    private Set<String> keySet;

    public Configuration() {
        File file;
        String propertiesFilename = null;
        String value = System.getenv(ANTUBLUE_TEST_ENGINE_PROPERTIES_ENVIRONMENT_VARIABLE);
        if (value != null && !value.trim().isEmpty()) {
            propertiesFilename = value.trim();
        }
        if (propertiesFilename == null && (value = System.getProperty(ANTUBLUE_TEST_ENGINE_PROPERTIES_SYSTEM_PROPERTY)) != null && !value.trim().isEmpty()) {
            propertiesFilename = value.trim();
        }
        if (propertiesFilename == null && (file = new File(ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME)).exists() && file.canRead() && file.isFile()) {
            propertiesFilename = file.getAbsolutePath();
        }
        if (propertiesFilename == null) {
            AtomicReference<String> atomicReference = new AtomicReference<String>();
            this.recursivelyFindTestEnginePropertiesFile(new File(".").getAbsoluteFile(), atomicReference);
            propertiesFilename = atomicReference.get();
        }
        if (propertiesFilename == null && (file = new File(USER_HOME + "/" + ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME)).exists() && file.canRead() && file.isFile()) {
            propertiesFilename = file.getAbsolutePath();
        }
        this.trace("properties filename [%s]", propertiesFilename);
        if (propertiesFilename != null) {
            this.trace("loading properties filename [%s]", propertiesFilename);
            try (FileReader reader = new FileReader(propertiesFilename);){
                this.properties.load(reader);
                TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
                for (Object key : this.properties.keySet()) {
                    map.put((String)key, true);
                }
                this.keySet = map.keySet();
                this.trace("properties loaded filename [%s]", propertiesFilename);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.keySet == null) {
            this.keySet = new HashSet<String>();
        }
    }

    public static Configuration singleton() {
        return SINGLETON;
    }

    public Optional<String> get(String key) {
        String value = this.properties.getProperty(key);
        this.trace("get name [%s] value [%s]", key, value);
        return Optional.ofNullable(value);
    }

    public Optional<Boolean> getBoolean(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            String string = value.get();
            this.trace("getBoolean name [%s] value [%s]", key, string);
            return Optional.of(Boolean.parseBoolean(string));
        }
        this.trace("getBoolean name [%s] value [%s]", key, null);
        return Optional.empty();
    }

    public int size() {
        return this.properties.size();
    }

    public Set<String> keySet() {
        return this.keySet;
    }

    private void recursivelyFindTestEnginePropertiesFile(File directory, AtomicReference<String> atomicReference) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.exists() || !f.isFile() || !f.canRead() || !ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME.equals(f.getName())) continue;
                atomicReference.set(f.getAbsolutePath());
                return;
            }
        }
        if (directory.getParentFile() != null) {
            this.recursivelyFindTestEnginePropertiesFile(directory.getParentFile(), atomicReference);
        }
    }

    private void trace(String format, Object ... objects) {
        if (TRACE) {
            System.out.println("[TRACE] " + this.getClass().getName() + " " + String.format(format, objects));
            System.out.flush();
        }
    }
}

