/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.descriptor;

import java.util.Optional;
import org.antublue.test.engine.internal.configuration.Configuration;
import org.antublue.test.engine.internal.test.descriptor.Metadata;
import org.antublue.test.engine.internal.test.descriptor.MetadataSupport;
import org.antublue.test.engine.internal.test.util.ThrowableContext;
import org.antublue.test.engine.internal.util.StopWatch;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

public abstract class ExecutableTestDescriptor
extends AbstractTestDescriptor
implements MetadataSupport {
    private final ThrowableContext throwableContext;
    private final Metadata metadata;
    private final StopWatch stopWatch = new StopWatch();
    private ExecutionRequest executionRequest;
    private long throttleMilliseconds;
    private Object testInstance;

    protected ExecutableTestDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
        this.throwableContext = new ThrowableContext();
        this.metadata = new Metadata();
        Configuration.singleton().get("antublue.test.engine.thread.throttle.milliseconds").ifPresent(s -> {
            try {
                this.throttleMilliseconds = Long.parseLong(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    protected void throttle() {
        if (this.throttleMilliseconds > 0L) {
            try {
                Thread.sleep(this.throttleMilliseconds);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void setExecutionRequest(ExecutionRequest executionRequest) {
        this.executionRequest = executionRequest;
    }

    protected ExecutionRequest getExecutionRequest() {
        return this.executionRequest;
    }

    public <T> T getParent(Class<T> clazz) {
        Optional optional = this.getParent();
        Preconditions.condition((boolean)optional.isPresent(), (String)"parent is null");
        return clazz.cast(optional.get());
    }

    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    protected void setTestInstance(Object testInstance) {
        this.testInstance = testInstance;
    }

    public Object getTestInstance() {
        return this.testInstance;
    }

    public ThrowableContext getThrowableContext() {
        return this.throwableContext;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    public abstract void execute(ExecutionRequest var1);
}

