/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.descriptor.filter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public class AnnotationFieldFilter
implements Predicate<Field> {
    private final List<Class<? extends Annotation>> annotations;

    private AnnotationFieldFilter(List<Class<? extends Annotation>> annotations) {
        this.annotations = annotations;
    }

    @Override
    public boolean test(Field field) {
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (!field.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    public static AnnotationFieldFilter of(Class<? extends Annotation> annotation) {
        return AnnotationFieldFilter.of(Collections.singletonList(annotation));
    }

    @SafeVarargs
    public static AnnotationFieldFilter of(Class<? extends Annotation> ... annotations) {
        return new AnnotationFieldFilter(new ArrayList<Class<? extends Annotation>>(Arrays.asList(annotations)));
    }

    public static AnnotationFieldFilter of(List<Class<? extends Annotation>> annotations) {
        return new AnnotationFieldFilter(annotations);
    }
}

