/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.descriptor.parameterized;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.exception.TestClassFailedException;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.test.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.test.descriptor.MetadataConstants;
import org.antublue.test.engine.internal.test.descriptor.filter.AnnotationFieldFilter;
import org.antublue.test.engine.internal.test.descriptor.filter.AnnotationMethodFilter;
import org.antublue.test.engine.internal.test.descriptor.parameterized.ParameterizedClassTestDescriptor;
import org.antublue.test.engine.internal.test.descriptor.parameterized.ParameterizedMethodTestDescriptor;
import org.antublue.test.engine.internal.test.extension.ExtensionManager;
import org.antublue.test.engine.internal.test.util.AutoCloseAnnotationProcessor;
import org.antublue.test.engine.internal.test.util.LockAnnotationProcessor;
import org.antublue.test.engine.internal.test.util.RandomAnnotationProcessor;
import org.antublue.test.engine.internal.test.util.StateMachine;
import org.antublue.test.engine.internal.test.util.TestUtils;
import org.antublue.test.engine.internal.util.StandardStreams;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ParameterizedArgumentTestDescriptor
extends ExecutableTestDescriptor {
    protected static final ExtensionManager EXTENSION_MANAGER = ExtensionManager.getSingleton();
    private final Class<?> testClass;
    private final int testArgumentIndex;
    private final Argument testArgument;
    private final List<Field> testArgumentFields;
    private final List<Field> randomFields;
    private final List<Field> autoCloseFields;
    private final List<Method> beforeAllMethods;
    private final List<Method> afterAllMethods;

    private ParameterizedArgumentTestDescriptor(Builder builder) {
        super(builder.uniqueId, builder.displayName);
        this.testClass = builder.testClass;
        this.testArgumentIndex = builder.testArgumentIndex;
        this.testArgument = builder.testArgument;
        this.testArgumentFields = builder.testArgumentFields;
        this.randomFields = builder.randomFields;
        this.autoCloseFields = builder.autoCloseFields;
        this.beforeAllMethods = builder.beforeAllMethods;
        this.afterAllMethods = builder.afterAllMethods;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    public Argument getTestArgument() {
        return this.testArgument;
    }

    @Override
    public void execute(ExecutionRequest executionRequest) {
        this.getStopWatch().start();
        Object testInstance = this.getParent(ExecutableTestDescriptor.class).getTestInstance();
        Preconditions.notNull((Object)testInstance, (String)"testInstance is null");
        this.setTestInstance(testInstance);
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testArgument", this.testArgument);
        if (!this.getThrowableContext().isEmpty()) {
            this.getChildren().forEach(testDescriptor -> {
                if (testDescriptor instanceof ExecutableTestDescriptor) {
                    ((ExecutableTestDescriptor)testDescriptor).execute(executionRequest);
                }
            });
            this.getStopWatch().stop();
            this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoTime());
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.SKIP);
            executionRequest.getEngineExecutionListener().executionSkipped((TestDescriptor)this, "");
            return;
        }
        this.setExecutionRequest(executionRequest);
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this);
        StateMachine<State> stateMachine = new StateMachine<State>(this.getUniqueId().toString()).define(State.BEGIN, this::begin, State.SET_ARGUMENT_FIELDS).define(State.SET_ARGUMENT_FIELDS, this::setArgumentFields, (State[])new State[]{State.SET_RANDOM_FIELDS, State.EXECUTE_OR_SKIP}).define(State.SET_RANDOM_FIELDS, this::setRandomFields, (State[])new State[]{State.PRE_BEFORE_ALL, State.EXECUTE_OR_SKIP}).define(State.PRE_BEFORE_ALL, this::preBeforeAll, (State[])new State[]{State.BEFORE_ALL, State.POST_BEFORE_ALL}).define(State.BEFORE_ALL, this::beforeAll, (State[])new State[]{State.POST_BEFORE_ALL}).define(State.POST_BEFORE_ALL, this::postBeforeAll, (State[])new State[]{State.EXECUTE_OR_SKIP}).define(State.EXECUTE_OR_SKIP, this::executeOrSkip, (State[])new State[]{State.PRE_AFTER_ALL}).define(State.PRE_AFTER_ALL, this::preAfterAll, (State[])new State[]{State.AFTER_ALL, State.POST_AFTER_ALL}).define(State.AFTER_ALL, this::afterAll, (State[])new State[]{State.POST_AFTER_ALL}).define(State.POST_AFTER_ALL, this::postAfterAll, (State[])new State[]{State.CLOSE_AUTO_CLOSE_FIELDS}).define(State.CLOSE_AUTO_CLOSE_FIELDS, this::closeAutoCloseFields, (State[])new State[]{State.CLEAR_ARGUMENTS_FIELDS}).define(State.CLEAR_ARGUMENTS_FIELDS, this::clearArgumentFields, (State[])new State[]{State.END}).afterEach(() -> {
            StandardStreams.flush();
            this.throttle();
            return null;
        }).end(State.END, this::end);
        try {
            stateMachine.run(State.BEGIN);
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        this.setExecutionRequest(null);
        this.getStopWatch().stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoTime());
        if (this.getThrowableContext().isEmpty()) {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.PASS);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.getParent(ParameterizedClassTestDescriptor.class).getThrowableContext().add(this.getTestInstance().getClass(), new TestClassFailedException(String.format("Exception testing test class [%s]", TestUtils.getDisplayName(this.testClass))));
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.FAIL);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.getThrowableContext().getThrowables().get(0)));
        }
        StandardStreams.flush();
    }

    private State begin() {
        return State.SET_ARGUMENT_FIELDS;
    }

    private State setArgumentFields() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        try {
            for (Field field : this.testArgumentFields) {
                field.setAccessible(true);
                field.set(this.getTestInstance(), this.testArgument);
                if (this.getThrowableContext().isEmpty()) continue;
                return State.EXECUTE_OR_SKIP;
            }
            return State.SET_RANDOM_FIELDS;
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
            return State.EXECUTE_OR_SKIP;
        }
    }

    private State setRandomFields() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        try {
            for (Field field : this.randomFields) {
                RandomAnnotationProcessor.inject(this.getTestInstance(), field);
                if (this.getThrowableContext().isEmpty()) continue;
                return State.EXECUTE_OR_SKIP;
            }
            return State.PRE_BEFORE_ALL;
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
            return State.EXECUTE_OR_SKIP;
        }
    }

    private State preBeforeAll() {
        EXTENSION_MANAGER.preBeforeAllMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.BEFORE_ALL;
        }
        return State.POST_BEFORE_ALL;
    }

    private State beforeAll() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        try {
            for (Method method : this.beforeAllMethods) {
                LockAnnotationProcessor.processLocks(method);
                TestUtils.invoke(method, this.getTestInstance(), this.testArgument, this.getThrowableContext());
                LockAnnotationProcessor.processUnlocks(method);
                if (this.getThrowableContext().isEmpty()) continue;
                break;
            }
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        return State.POST_BEFORE_ALL;
    }

    private State postBeforeAll() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.postBeforeAllMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        return State.EXECUTE_OR_SKIP;
    }

    private State executeOrSkip() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).execute(this.getExecutionRequest());
            }
        });
        return State.PRE_AFTER_ALL;
    }

    private State preAfterAll() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.preAfterAllMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.AFTER_ALL;
        }
        return State.POST_AFTER_ALL;
    }

    private State afterAll() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        for (Method method : this.afterAllMethods) {
            LockAnnotationProcessor.processLocks(method);
            TestUtils.invoke(method, this.getTestInstance(), this.testArgument, this.getThrowableContext());
            LockAnnotationProcessor.processUnlocks(method);
        }
        return State.POST_AFTER_ALL;
    }

    private State postAfterAll() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.postAfterAllMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        return State.CLOSE_AUTO_CLOSE_FIELDS;
    }

    private State closeAutoCloseFields() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        AutoCloseAnnotationProcessor autoCloseAnnotationProcessor = AutoCloseAnnotationProcessor.getSingleton();
        for (Field testField : this.autoCloseFields) {
            autoCloseAnnotationProcessor.close(this.getTestInstance(), testField, this.getThrowableContext());
        }
        return State.CLEAR_ARGUMENTS_FIELDS;
    }

    private State clearArgumentFields() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        for (Field field : this.testArgumentFields) {
            try {
                field.set(this.getTestInstance(), null);
            }
            catch (Throwable t) {
                this.getThrowableContext().add(this.testClass, t);
            }
        }
        return State.END;
    }

    private State end() {
        return null;
    }

    public static class Builder {
        private Class<?> testClass;
        private int testArgumentIndex;
        private Argument testArgument;
        private List<Method> testMethods;
        private UniqueId uniqueId;
        private String displayName;
        private List<Field> testArgumentFields;
        private List<Field> randomFields;
        private List<Field> autoCloseFields;
        private List<Method> beforeAllMethods;
        private List<Method> afterAllMethods;

        public Builder setTestClass(Class<?> testClass) {
            this.testClass = testClass;
            return this;
        }

        public Builder setTestArgument(int testArgumentIndex, Argument testArgument) {
            this.testArgumentIndex = testArgumentIndex;
            this.testArgument = testArgument;
            return this;
        }

        public Builder setTestMethods(List<Method> testMethods) {
            this.testMethods = testMethods;
            return this;
        }

        public void build(TestDescriptor parentTestDescriptor) {
            try {
                this.uniqueId = parentTestDescriptor.getUniqueId().append(ParameterizedArgumentTestDescriptor.class.getName(), this.testArgumentIndex + "/" + this.testArgument.name());
                this.displayName = this.testArgument.name();
                this.testArgumentFields = ReflectionSupport.findFields(this.testClass, (Predicate)AnnotationFieldFilter.of(TestEngine.Argument.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                this.randomFields = ReflectionSupport.findFields(this.testClass, (Predicate)AnnotationFieldFilter.of(TestEngine.Random.UUID.class, TestEngine.Random.Boolean.class, TestEngine.Random.Byte.class, TestEngine.Random.Character.class, TestEngine.Random.Short.class, TestEngine.Random.Integer.class, TestEngine.Random.Long.class, TestEngine.Random.Float.class, TestEngine.Random.Double.class, TestEngine.Random.BigInteger.class, TestEngine.Random.BigDecimal.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                this.autoCloseFields = ReflectionSupport.findFields(this.testClass, (Predicate)AnnotationFieldFilter.of(TestEngine.AutoClose.AfterAll.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                this.beforeAllMethods = ReflectionSupport.findMethods(this.testClass, (Predicate)AnnotationMethodFilter.of(TestEngine.BeforeAll.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                this.beforeAllMethods = TestUtils.orderTestMethods(this.beforeAllMethods, HierarchyTraversalMode.TOP_DOWN);
                this.afterAllMethods = ReflectionSupport.findMethods(this.testClass, (Predicate)AnnotationMethodFilter.of(TestEngine.AfterAll.class), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
                this.afterAllMethods = TestUtils.orderTestMethods(this.afterAllMethods, HierarchyTraversalMode.BOTTOM_UP);
                ParameterizedArgumentTestDescriptor testDescriptor = new ParameterizedArgumentTestDescriptor(this);
                parentTestDescriptor.addChild((TestDescriptor)testDescriptor);
                for (Method testMethod : this.testMethods) {
                    new ParameterizedMethodTestDescriptor.Builder().setTestClass(this.testClass).setTestArgument(this.testArgumentIndex, this.testArgument).setTestMethod(testMethod).build((TestDescriptor)testDescriptor);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new TestEngineException(t);
            }
        }
    }

    private static enum State {
        BEGIN,
        SET_ARGUMENT_FIELDS,
        SET_RANDOM_FIELDS,
        PRE_BEFORE_ALL,
        BEFORE_ALL,
        POST_BEFORE_ALL,
        EXECUTE_OR_SKIP,
        PRE_AFTER_ALL,
        AFTER_ALL,
        POST_AFTER_ALL,
        CLEAR_ARGUMENTS_FIELDS,
        CLOSE_AUTO_CLOSE_FIELDS,
        END;

    }
}

