/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.descriptor.parameterized;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.test.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.test.descriptor.MetadataConstants;
import org.antublue.test.engine.internal.test.descriptor.filter.AnnotationFieldFilter;
import org.antublue.test.engine.internal.test.descriptor.filter.AnnotationMethodFilter;
import org.antublue.test.engine.internal.test.descriptor.parameterized.ParameterizedArgumentTestDescriptor;
import org.antublue.test.engine.internal.test.extension.ExtensionManager;
import org.antublue.test.engine.internal.test.util.AutoCloseAnnotationProcessor;
import org.antublue.test.engine.internal.test.util.LockAnnotationProcessor;
import org.antublue.test.engine.internal.test.util.ReflectionUtils;
import org.antublue.test.engine.internal.test.util.StateMachine;
import org.antublue.test.engine.internal.test.util.TestUtils;
import org.antublue.test.engine.internal.test.util.ThrowableContext;
import org.antublue.test.engine.internal.util.StandardStreams;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ParameterizedClassTestDescriptor
extends ExecutableTestDescriptor {
    protected static final ExtensionManager EXTENSION_MANAGER = ExtensionManager.getSingleton();
    private final Class<?> testClass;
    private final List<Field> autoCloseFields;
    private final List<Method> prepareMethods;
    private final List<Method> concludeMethods;

    private ParameterizedClassTestDescriptor(Builder builder) {
        super(builder.uniqueId, builder.displayName);
        this.testClass = builder.testClass;
        this.autoCloseFields = builder.autoCloseFields;
        this.prepareMethods = builder.prepareMethods;
        this.concludeMethods = builder.concludeMethods;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER_AND_TEST;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public String getTag() {
        return TestUtils.getTag(this.testClass);
    }

    @Override
    public void execute(ExecutionRequest executionRequest) {
        this.getStopWatch().start();
        this.getMetadata().put("testClass", this.testClass);
        this.setExecutionRequest(executionRequest);
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this);
        StateMachine<State> stateMachine = new StateMachine<State>(this.getUniqueId().toString()).define(State.BEGIN, this::begin, State.PRE_INSTANTIATE).define(State.PRE_INSTANTIATE, this::preInstantiate, (State[])new State[]{State.INSTANTIATE, State.POST_INSTANTIATE}).define(State.INSTANTIATE, this::instantiate, (State[])new State[]{State.POST_INSTANTIATE}).define(State.POST_INSTANTIATE, this::postInstantiate, (State[])new State[]{State.PRE_PREPARE, State.EXECUTE_OR_SKIP}).define(State.PRE_PREPARE, this::prePrepare, (State[])new State[]{State.PREPARE, State.POST_PREPARE}).define(State.PREPARE, this::prepare, (State[])new State[]{State.POST_PREPARE}).define(State.POST_PREPARE, this::postPrepare, (State[])new State[]{State.EXECUTE_OR_SKIP}).define(State.EXECUTE_OR_SKIP, this::executeOrSkip, (State[])new State[]{State.PRE_CONCLUDE}).define(State.PRE_CONCLUDE, this::preConclude, (State[])new State[]{State.CONCLUDE, State.POST_CONCLUDE}).define(State.CONCLUDE, this::conclude, (State[])new State[]{State.POST_CONCLUDE}).define(State.POST_CONCLUDE, this::postConclude, (State[])new State[]{State.CLOSE_AUTO_CLOSE_FIELDS}).define(State.CLOSE_AUTO_CLOSE_FIELDS, this::closeAutoCloseFields, (State[])new State[]{State.END}).afterEach(() -> {
            StandardStreams.flush();
            this.throttle();
            return null;
        }).end(State.END, this::end);
        try {
            stateMachine.run(State.BEGIN);
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        this.setExecutionRequest(null);
        this.setTestInstance(null);
        this.getStopWatch().stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoTime());
        if (this.getThrowableContext().isEmpty()) {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.PASS);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.FAIL);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.getThrowableContext().getThrowables().get(0)));
        }
        StandardStreams.flush();
    }

    private State begin() {
        return State.PRE_INSTANTIATE;
    }

    private State preInstantiate() {
        LockAnnotationProcessor.processLock(this.getTestClass());
        EXTENSION_MANAGER.preInstantiateCallback(this.testClass, this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.INSTANTIATE;
        }
        return State.END;
    }

    private State instantiate() {
        Preconditions.condition((boolean)this.getThrowableContext().isEmpty(), (String)"Programming error");
        try {
            this.setTestInstance(ReflectionUtils.newInstance(this.testClass));
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        return State.POST_INSTANTIATE;
    }

    private State postInstantiate() {
        EXTENSION_MANAGER.postInstantiateCallback(this.getTestInstance(), this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.PRE_PREPARE;
        }
        return State.END;
    }

    private State prePrepare() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.prePrepareMethodsCallback(this.getTestInstance(), this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.PREPARE;
        }
        return State.POST_PREPARE;
    }

    private State prepare() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        try {
            for (Method method : this.prepareMethods) {
                LockAnnotationProcessor.processLocks(method);
                TestUtils.invoke(method, this.getTestInstance(), null, this.getThrowableContext());
                LockAnnotationProcessor.processUnlocks(method);
                if (this.getThrowableContext().isEmpty()) continue;
                break;
            }
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        return State.POST_PREPARE;
    }

    private State postPrepare() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.postPrepareMethodsCallback(this.getTestInstance(), this.getThrowableContext());
        return State.EXECUTE_OR_SKIP;
    }

    private State executeOrSkip() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        this.getChildren().forEach(testDescriptor -> {
            if (testDescriptor instanceof ExecutableTestDescriptor) {
                ((ExecutableTestDescriptor)testDescriptor).execute(this.getExecutionRequest());
            }
        });
        return State.PRE_CONCLUDE;
    }

    private State preConclude() {
        EXTENSION_MANAGER.preConcludeMethodsCallback(this.getTestInstance(), this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.CONCLUDE;
        }
        return State.POST_CONCLUDE;
    }

    private State conclude() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        for (Method method : this.concludeMethods) {
            LockAnnotationProcessor.processLocks(method);
            TestUtils.invoke(method, this.getTestInstance(), null, this.getThrowableContext());
            LockAnnotationProcessor.processUnlocks(method);
        }
        return State.POST_CONCLUDE;
    }

    private State postConclude() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.postConcludeMethodsCallback(this.getTestInstance(), this.getThrowableContext());
        return State.CLOSE_AUTO_CLOSE_FIELDS;
    }

    private State closeAutoCloseFields() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        AutoCloseAnnotationProcessor autoCloseAnnotationProcessor = AutoCloseAnnotationProcessor.getSingleton();
        for (Field field : this.autoCloseFields) {
            autoCloseAnnotationProcessor.close(this.getTestInstance(), field, this.getThrowableContext());
        }
        return State.END;
    }

    private State end() {
        EXTENSION_MANAGER.preDestroyCallback(this.testClass, Optional.ofNullable(this.getTestInstance()), new ThrowableContext());
        LockAnnotationProcessor.processUnlocks(this.getTestClass());
        return null;
    }

    public static class Builder {
        private Class<?> testClass;
        private List<Argument> testArguments;
        private List<Method> testMethods;
        private UniqueId uniqueId;
        private String displayName;
        private List<Field> autoCloseFields;
        private List<Method> prepareMethods;
        private List<Method> concludeMethods;

        public Builder setTestClass(Class<?> testClass) {
            this.testClass = testClass;
            return this;
        }

        public Builder setTestArguments(List<Argument> testArguments) {
            this.testArguments = testArguments;
            return this;
        }

        public Builder setTestMethods(List<Method> testMethods) {
            this.testMethods = testMethods;
            return this;
        }

        public void build(TestDescriptor parentTestDescriptor) {
            try {
                this.uniqueId = parentTestDescriptor.getUniqueId().append(ParameterizedClassTestDescriptor.class.getName(), this.testClass.getName());
                this.displayName = TestUtils.getDisplayName(this.testClass);
                this.prepareMethods = ReflectionSupport.findMethods(this.testClass, (Predicate)AnnotationMethodFilter.of(TestEngine.Prepare.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                this.prepareMethods = TestUtils.orderTestMethods(this.prepareMethods, HierarchyTraversalMode.TOP_DOWN);
                this.concludeMethods = ReflectionSupport.findMethods(this.testClass, (Predicate)AnnotationMethodFilter.of(TestEngine.Conclude.class), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
                this.concludeMethods = TestUtils.orderTestMethods(this.concludeMethods, HierarchyTraversalMode.BOTTOM_UP);
                this.autoCloseFields = ReflectionSupport.findFields(this.testClass, (Predicate)AnnotationFieldFilter.of(TestEngine.AutoClose.Conclude.class), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
                ParameterizedClassTestDescriptor testDescriptor = new ParameterizedClassTestDescriptor(this);
                parentTestDescriptor.addChild((TestDescriptor)testDescriptor);
                int testArgumentIndex = 0;
                for (Argument testArgument : this.testArguments) {
                    new ParameterizedArgumentTestDescriptor.Builder().setTestClass(this.testClass).setTestArgument(testArgumentIndex, testArgument).setTestMethods(this.testMethods).build((TestDescriptor)testDescriptor);
                    ++testArgumentIndex;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new TestEngineException(t);
            }
        }
    }

    private static enum State {
        BEGIN,
        PRE_INSTANTIATE,
        INSTANTIATE,
        POST_INSTANTIATE,
        PRE_PREPARE,
        PREPARE,
        POST_PREPARE,
        EXECUTE_OR_SKIP,
        PRE_CONCLUDE,
        CONCLUDE,
        POST_CONCLUDE,
        CLOSE_AUTO_CLOSE_FIELDS,
        END;

    }
}

