/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.descriptor.parameterized;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.exception.TestArgumentFailedException;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.test.descriptor.ExecutableTestDescriptor;
import org.antublue.test.engine.internal.test.descriptor.MetadataConstants;
import org.antublue.test.engine.internal.test.descriptor.filter.AnnotationFieldFilter;
import org.antublue.test.engine.internal.test.descriptor.filter.AnnotationMethodFilter;
import org.antublue.test.engine.internal.test.descriptor.parameterized.ParameterizedArgumentTestDescriptor;
import org.antublue.test.engine.internal.test.extension.ExtensionManager;
import org.antublue.test.engine.internal.test.util.AutoCloseAnnotationProcessor;
import org.antublue.test.engine.internal.test.util.LockAnnotationProcessor;
import org.antublue.test.engine.internal.test.util.StateMachine;
import org.antublue.test.engine.internal.test.util.TestUtils;
import org.antublue.test.engine.internal.util.StandardStreams;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public class ParameterizedMethodTestDescriptor
extends ExecutableTestDescriptor {
    protected static final ExtensionManager EXTENSION_MANAGER = ExtensionManager.getSingleton();
    private final Class<?> testClass;
    private final Argument testArgument;
    private final List<Field> autoCloseFields;
    private final List<Method> beforeEachMethods;
    private final Method testMethod;
    private final List<Method> afterEachMethods;

    private ParameterizedMethodTestDescriptor(Builder builder) {
        super(builder.uniqueId, builder.displayName);
        this.testClass = builder.testClass;
        this.testArgument = builder.testArgument;
        this.autoCloseFields = builder.autoCloseFields;
        this.beforeEachMethods = builder.beforeEachMethods;
        this.testMethod = builder.testMethod;
        this.afterEachMethods = builder.afterEachMethods;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    public Optional<TestSource> getSource() {
        return Optional.of(MethodSource.from((Method)this.testMethod));
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public String getTag() {
        return TestUtils.getTag(this.testMethod);
    }

    @Override
    public void execute(ExecutionRequest executionRequest) {
        this.getStopWatch().start();
        Object testInstance = this.getParent(ExecutableTestDescriptor.class).getTestInstance();
        Preconditions.notNull((Object)testInstance, (String)"testInstance is null");
        this.setTestInstance(testInstance);
        this.getMetadata().put("testClass", this.testClass);
        this.getMetadata().put("testArgument", this.testArgument);
        this.getMetadata().put("testMethod", this.testMethod);
        if (!this.getThrowableContext().isEmpty()) {
            this.getStopWatch().stop();
            this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoTime());
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.SKIP);
            executionRequest.getEngineExecutionListener().executionSkipped((TestDescriptor)this, "");
            return;
        }
        this.setExecutionRequest(executionRequest);
        executionRequest.getEngineExecutionListener().executionStarted((TestDescriptor)this);
        StateMachine<State> stateMachine = new StateMachine<State>(this.getUniqueId().toString()).define(State.BEGIN, this::begin, State.PRE_BEFORE_EACH).define(State.PRE_BEFORE_EACH, this::preBeforeEach, (State[])new State[]{State.BEFORE_EACH, State.POST_BEFORE_EACH}).define(State.BEFORE_EACH, this::beforeEach, (State[])new State[]{State.POST_BEFORE_EACH}).define(State.POST_BEFORE_EACH, this::postBeforeEach, (State[])new State[]{State.PRE_TEST}).define(State.PRE_TEST, this::preTest, (State[])new State[]{State.TEST, State.POST_TEST}).define(State.TEST, this::test, (State[])new State[]{State.POST_TEST}).define(State.POST_TEST, this::postTest, (State[])new State[]{State.PRE_AFTER_EACH}).define(State.PRE_AFTER_EACH, this::preAfterEach, (State[])new State[]{State.AFTER_EACH, State.POST_AFTER_EACH}).define(State.AFTER_EACH, this::afterEach, (State[])new State[]{State.POST_AFTER_EACH}).define(State.POST_AFTER_EACH, this::postAfterEach, (State[])new State[]{State.CLOSE_AUTO_CLOSE_FIELDS}).define(State.CLOSE_AUTO_CLOSE_FIELDS, this::closeAutoCloseFields, (State[])new State[]{State.END}).afterEach(() -> {
            StandardStreams.flush();
            this.throttle();
            return null;
        }).end(State.END, this::end);
        try {
            stateMachine.run(State.BEGIN);
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        this.setExecutionRequest(null);
        this.setTestInstance(null);
        this.getStopWatch().stop();
        this.getMetadata().put("testDescriptorElapsedTime", this.getStopWatch().elapsedNanoTime());
        if (this.getThrowableContext().isEmpty()) {
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.PASS);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        } else {
            this.getParent(ParameterizedArgumentTestDescriptor.class).getThrowableContext().add(this.testClass, new TestArgumentFailedException(String.format("Exception testing test argument name [%s]", this.testArgument.name())));
            this.getMetadata().put("testDescriptorStatus", MetadataConstants.FAIL);
            executionRequest.getEngineExecutionListener().executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)this.getThrowableContext().getThrowables().get(0)));
        }
        StandardStreams.flush();
    }

    private State begin() {
        return State.PRE_BEFORE_EACH;
    }

    private State preBeforeEach() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.preBeforeEachMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.BEFORE_EACH;
        }
        return State.POST_BEFORE_EACH;
    }

    private State beforeEach() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        try {
            for (Method method : this.beforeEachMethods) {
                LockAnnotationProcessor.processLocks(method);
                TestUtils.invoke(method, this.getTestInstance(), this.testArgument, this.getThrowableContext());
                LockAnnotationProcessor.processUnlocks(method);
                if (this.getThrowableContext().isEmpty()) continue;
                break;
            }
        }
        catch (Throwable t) {
            this.getThrowableContext().add(this.testClass, t);
        }
        return State.POST_BEFORE_EACH;
    }

    private State postBeforeEach() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.postBeforeEachMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.PRE_TEST;
        }
        return State.PRE_AFTER_EACH;
    }

    private State preTest() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.preTestMethodsCallback(this.testMethod, this.getTestInstance(), this.testArgument, this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.TEST;
        }
        return State.POST_TEST;
    }

    private State test() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        LockAnnotationProcessor.processLocks(this.testMethod);
        TestUtils.invoke(this.testMethod, this.getTestInstance(), this.testArgument, this.getThrowableContext());
        LockAnnotationProcessor.processUnlocks(this.testMethod);
        return State.POST_TEST;
    }

    private State postTest() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.postTestMethodsCallback(this.testMethod, this.getTestInstance(), this.testArgument, this.getThrowableContext());
        return State.PRE_AFTER_EACH;
    }

    private State preAfterEach() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.preAfterEachMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        if (this.getThrowableContext().isEmpty()) {
            return State.AFTER_EACH;
        }
        return State.POST_AFTER_EACH;
    }

    private State afterEach() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        for (Method method : this.afterEachMethods) {
            LockAnnotationProcessor.processLocks(method);
            TestUtils.invoke(method, this.getTestInstance(), this.testArgument, this.getThrowableContext());
            LockAnnotationProcessor.processUnlocks(method);
        }
        return State.POST_AFTER_EACH;
    }

    private State postAfterEach() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        EXTENSION_MANAGER.postAfterEachMethodsCallback(this.getTestInstance(), this.testArgument, this.getThrowableContext());
        return State.CLOSE_AUTO_CLOSE_FIELDS;
    }

    private State closeAutoCloseFields() {
        Preconditions.notNull((Object)this.getTestInstance(), (String)"testInstance is null");
        AutoCloseAnnotationProcessor autoCloseAnnotationProcessor = AutoCloseAnnotationProcessor.getSingleton();
        for (Field field : this.autoCloseFields) {
            autoCloseAnnotationProcessor.close(this.getTestInstance(), field, this.getThrowableContext());
        }
        return State.END;
    }

    private State end() {
        return null;
    }

    public static class Builder {
        private Class<?> testClass;
        private int testArgumentIndex;
        private Argument testArgument;
        private Method testMethod;
        private UniqueId uniqueId;
        private String displayName;
        private List<Field> autoCloseFields;
        private List<Method> beforeEachMethods;
        private List<Method> afterEachMethods;

        public Builder setTestClass(Class<?> testClass) {
            this.testClass = testClass;
            return this;
        }

        public Builder setTestArgument(int testArgumentIndex, Argument testArgument) {
            this.testArgumentIndex = testArgumentIndex;
            this.testArgument = testArgument;
            return this;
        }

        public Builder setTestMethod(Method testMethod) {
            this.testMethod = testMethod;
            return this;
        }

        public void build(TestDescriptor parentTestDescriptor) {
            try {
                this.uniqueId = parentTestDescriptor.getUniqueId().append(ParameterizedMethodTestDescriptor.class.getName(), this.testMethod.getName());
                this.displayName = TestUtils.getDisplayName(this.testMethod);
                this.autoCloseFields = ReflectionSupport.findFields(this.testClass, (Predicate)AnnotationFieldFilter.of(TestEngine.AutoClose.AfterEach.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                this.beforeEachMethods = ReflectionSupport.findMethods(this.testClass, (Predicate)AnnotationMethodFilter.of(TestEngine.BeforeEach.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
                this.beforeEachMethods = TestUtils.orderTestMethods(this.beforeEachMethods, HierarchyTraversalMode.TOP_DOWN);
                this.afterEachMethods = ReflectionSupport.findMethods(this.testClass, (Predicate)AnnotationMethodFilter.of(TestEngine.AfterEach.class), (HierarchyTraversalMode)HierarchyTraversalMode.BOTTOM_UP);
                this.afterEachMethods = TestUtils.orderTestMethods(this.afterEachMethods, HierarchyTraversalMode.BOTTOM_UP);
                ParameterizedMethodTestDescriptor testDescriptor = new ParameterizedMethodTestDescriptor(this);
                parentTestDescriptor.addChild((TestDescriptor)testDescriptor);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new TestEngineException(t);
            }
        }
    }

    private static enum State {
        BEGIN,
        PRE_BEFORE_EACH,
        BEFORE_EACH,
        POST_BEFORE_EACH,
        PRE_TEST,
        TEST,
        POST_TEST,
        PRE_AFTER_EACH,
        AFTER_EACH,
        POST_AFTER_EACH,
        CLOSE_AUTO_CLOSE_FIELDS,
        END;

    }
}

