/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.descriptor.parameterized;

import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.test.descriptor.filter.AnnotationMethodFilter;
import org.antublue.test.engine.internal.test.util.ReflectionUtils;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class ParameterizedTestPredicates {
    public static final Predicate<Class<?>> TEST_CLASS = new TestClassFilter();
    public static final Predicate<Method> TEST_METHOD = new TestMethodFilter();

    private static class TestMethodFilter
    implements Predicate<Method> {
        private TestMethodFilter() {
        }

        @Override
        public boolean test(Method method) {
            return !ReflectionUtils.isAbstract(method) && !method.isAnnotationPresent(TestEngine.Disabled.class) && method.isAnnotationPresent(TestEngine.Test.class);
        }
    }

    private static class TestClassFilter
    implements Predicate<Class<?>> {
        private TestClassFilter() {
        }

        @Override
        public boolean test(Class<?> clazz) {
            return !ReflectionUtils.isAbstract(clazz) && !clazz.isAnnotationPresent(TestEngine.Disabled.class) && !ReflectionSupport.findMethods(clazz, (Predicate)AnnotationMethodFilter.of(TestEngine.Test.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).isEmpty() && !ReflectionSupport.findMethods(clazz, (Predicate)AnnotationMethodFilter.of(TestEngine.ArgumentSupplier.class), (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN).isEmpty();
        }
    }
}

