/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.util;

import java.lang.reflect.Field;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public class ArgumentAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArgumentAnnotationProcessor.class);
    private static final ArgumentAnnotationProcessor SINGLETON = new ArgumentAnnotationProcessor();

    private ArgumentAnnotationProcessor() {
    }

    public static ArgumentAnnotationProcessor singleton() {
        return SINGLETON;
    }

    public void inject(Object testInstance, Argument testArgument, Field field) throws Throwable {
        TestEngine.Argument annotation = field.getAnnotation(TestEngine.Argument.class);
        if (annotation != null) {
            String name = null;
            if (testArgument != null) {
                name = testArgument.name();
            }
            LOGGER.trace("injecting argument class [%s] argument [%s] field [%s] field type [%s]", testInstance.getClass().getName(), name, field.getName(), field.getType().getName());
            field.set(testInstance, testArgument);
        }
    }
}

