/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.test.util.ThrowableContext;

public class AutoCloseAnnotationProcessor {
    private static final AutoCloseAnnotationProcessor SINGLETON = new AutoCloseAnnotationProcessor();
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoCloseAnnotationProcessor.class);

    private AutoCloseAnnotationProcessor() {
    }

    public static final AutoCloseAnnotationProcessor getSingleton() {
        return SINGLETON;
    }

    public void close(Object object, Field field, ThrowableContext throwableContext) {
        LOGGER.trace("close test class [%s] field [%s]", object.getClass().getName(), field.getName());
        try {
            String methodName = null;
            TestEngine.AutoClose.AfterEach autoCloseAfterEachAnnotation = field.getAnnotation(TestEngine.AutoClose.AfterEach.class);
            TestEngine.AutoClose.AfterAll autoCloseAfterAllAnnotation = field.getAnnotation(TestEngine.AutoClose.AfterAll.class);
            TestEngine.AutoClose.Conclude autoCloseConcludeAnnotation = field.getAnnotation(TestEngine.AutoClose.Conclude.class);
            if (autoCloseAfterEachAnnotation == null && autoCloseAfterAllAnnotation == null && autoCloseConcludeAnnotation == null) {
                return;
            }
            if (autoCloseAfterEachAnnotation != null) {
                methodName = autoCloseAfterEachAnnotation.method();
            } else if (autoCloseAfterAllAnnotation != null) {
                methodName = autoCloseAfterAllAnnotation.method();
            } else if (autoCloseConcludeAnnotation != null) {
                methodName = autoCloseConcludeAnnotation.method();
            }
            field.setAccessible(true);
            Object o = field.get(object);
            if (o == null) {
                return;
            }
            if (methodName == null || methodName.trim().isEmpty()) {
                if (o instanceof AutoCloseable) {
                    ((AutoCloseable)o).close();
                }
            } else if (!methodName.trim().isEmpty()) {
                Method method = o.getClass().getMethod(methodName.trim(), null);
                method.setAccessible(true);
                method.invoke(o, (Object[])null);
            }
        }
        catch (Throwable t) {
            throwableContext.add(object.getClass(), t);
        }
    }
}

