/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.exception.TestClassDefinitionException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;

public class LockAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockAnnotationProcessor.class);
    private static final Map<String, ReentrantReadWriteLock> LOCK_MAP = new ConcurrentHashMap<String, ReentrantReadWriteLock>();

    private LockAnnotationProcessor() {
    }

    public static void processLock(Class<?> clazz) {
        String name;
        TestEngine.ResourceLock annotation = clazz.getAnnotation(TestEngine.ResourceLock.class);
        if (annotation != null && (name = annotation.name()) != null && !name.trim().isEmpty()) {
            String trimmedName = name.trim();
            TestEngine.LockMode mode = annotation.mode();
            if (mode == TestEngine.LockMode.READ_WRITE) {
                LOCK_MAP.computeIfAbsent(trimmedName, n -> LockAnnotationProcessor.createLock(n, true)).writeLock().lock();
            } else {
                LOCK_MAP.computeIfAbsent(trimmedName, n -> LockAnnotationProcessor.createLock(n, true)).readLock().lock();
            }
        }
    }

    public static void processLocks(Method method) {
        Annotation[] annotations;
        if (!(method.isAnnotationPresent(TestEngine.Lock.class) || method.isAnnotationPresent(TestEngine.Lock.List.class) || method.isAnnotationPresent(TestEngine.ResourceLock.class) || method.isAnnotationPresent(TestEngine.ResourceLock.List.class))) {
            return;
        }
        for (Annotation annotation : annotations = method.getAnnotations()) {
            TestEngine.Lock.List lockListAnnotation;
            TestEngine.Lock lockAnnotation;
            if (annotation.annotationType().isAssignableFrom(TestEngine.Lock.class)) {
                lockAnnotation = (TestEngine.Lock)annotation;
                LockAnnotationProcessor.lock(method, lockAnnotation.name(), lockAnnotation.mode());
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.Lock.List.class)) {
                lockListAnnotation = (TestEngine.Lock.List)annotation;
                Stream.of(lockListAnnotation.value()).forEach(lock -> LockAnnotationProcessor.lock(method, lock.name(), lock.mode()));
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.class)) {
                lockAnnotation = (TestEngine.ResourceLock)annotation;
                LockAnnotationProcessor.lock(method, lockAnnotation.name(), lockAnnotation.mode());
                continue;
            }
            if (!annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.List.class)) continue;
            lockListAnnotation = (TestEngine.ResourceLock.List)annotation;
            Stream.of(lockListAnnotation.value()).forEach(lock -> LockAnnotationProcessor.lock(method, lock.name(), lock.mode()));
        }
    }

    private static void lock(Method method, String name, TestEngine.LockMode mode) {
        if (name != null && !name.trim().isEmpty()) {
            String trimmedName = name.trim();
            LOGGER.trace("Acquiring lock [%s] mode [%s] class [%s] method [%s]", trimmedName, mode, method.getDeclaringClass().getName(), method.getName());
            if (mode == TestEngine.LockMode.READ_WRITE) {
                LOCK_MAP.computeIfAbsent(trimmedName, n -> LockAnnotationProcessor.createLock(n, true)).writeLock().lock();
            } else {
                LOCK_MAP.computeIfAbsent(trimmedName, n -> LockAnnotationProcessor.createLock(n, true)).readLock().lock();
            }
            LOGGER.trace("Acquired lock [%s] mode [%s] class [%s] method [%s]", trimmedName, mode, method.getDeclaringClass().getName(), method.getName());
        }
    }

    public static void processUnlocks(Class<?> clazz) {
        String name;
        TestEngine.ResourceLock annotation = clazz.getAnnotation(TestEngine.ResourceLock.class);
        if (annotation != null && (name = annotation.name()) != null && !name.trim().isEmpty()) {
            String trimmedName = name.trim();
            TestEngine.LockMode mode = annotation.mode();
            ReentrantReadWriteLock reentrantReadWriteLock = LOCK_MAP.get(name);
            if (reentrantReadWriteLock != null) {
                LOGGER.trace("Releasing lock [%s] mode [%s] class [%s]", trimmedName, mode, clazz.getName());
                if (mode == TestEngine.LockMode.READ_WRITE) {
                    reentrantReadWriteLock.writeLock().unlock();
                } else {
                    reentrantReadWriteLock.readLock().unlock();
                }
                LOGGER.trace("Released lock [%s] mode [%s] class", trimmedName, mode, clazz.getName());
            } else {
                throw new TestClassDefinitionException(String.format("@TestEngine.Unlock without @TestEngine.Lock, name [%s] mode [%s] class [%s]", trimmedName, mode, clazz.getName()));
            }
        }
    }

    public static void processUnlocks(Method method) {
        Annotation[] annotations;
        if (!(method.isAnnotationPresent(TestEngine.Unlock.class) || method.isAnnotationPresent(TestEngine.Unlock.List.class) || method.isAnnotationPresent(TestEngine.ResourceLock.class) || method.isAnnotationPresent(TestEngine.ResourceLock.List.class))) {
            return;
        }
        for (Annotation annotation : annotations = method.getAnnotations()) {
            TestEngine.Unlock.List unlockListAnnotation;
            TestEngine.Unlock unlockAnnotation;
            if (annotation.annotationType().isAssignableFrom(TestEngine.Unlock.class)) {
                unlockAnnotation = (TestEngine.Unlock)annotation;
                LockAnnotationProcessor.unlock(method, unlockAnnotation.name(), unlockAnnotation.mode());
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.Unlock.List.class)) {
                unlockListAnnotation = (TestEngine.Unlock.List)annotation;
                Stream.of(unlockListAnnotation.value()).forEach(lock -> LockAnnotationProcessor.unlock(method, lock.name(), lock.mode()));
                continue;
            }
            if (annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.class)) {
                unlockAnnotation = (TestEngine.ResourceLock)annotation;
                LockAnnotationProcessor.unlock(method, unlockAnnotation.name(), unlockAnnotation.mode());
                continue;
            }
            if (!annotation.annotationType().isAssignableFrom(TestEngine.ResourceLock.List.class)) continue;
            unlockListAnnotation = (TestEngine.ResourceLock.List)annotation;
            List<TestEngine.ResourceLock> list = Arrays.asList(unlockListAnnotation.value());
            Collections.reverse(list);
            list.forEach(lock -> LockAnnotationProcessor.unlock(method, lock.name(), lock.mode()));
        }
    }

    private static void unlock(Method method, String name, TestEngine.LockMode mode) {
        if (name != null && !name.trim().isEmpty()) {
            ReentrantReadWriteLock reentrantReadWriteLock = LOCK_MAP.get(name);
            if (reentrantReadWriteLock != null) {
                LOGGER.trace("Releasing lock [%s] mode [%s] class [%s] method [%s]", name.trim(), mode, method.getDeclaringClass().getName(), method.getName());
                if (mode == TestEngine.LockMode.READ_WRITE) {
                    reentrantReadWriteLock.writeLock().unlock();
                } else {
                    reentrantReadWriteLock.readLock().unlock();
                }
                LOGGER.trace("Released lock [%s] mode [%s] class [%s] method [%s]", name.trim(), mode, method.getDeclaringClass().getName(), method.getName());
            } else {
                throw new TestClassDefinitionException(String.format("@TestEngine.Unlock without @TestEngine.Lock, name [%s] mode [%s] class [%s] method [%s]", name.trim(), mode, method.getDeclaringClass().getName(), method.getName()));
            }
        }
    }

    private static ReentrantReadWriteLock createLock(String name, boolean fair) {
        LOGGER.trace("createLock name [%s] fair [%b]", name, fair);
        return new ReentrantReadWriteLock(fair);
    }
}

