/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.util;

import java.lang.reflect.Field;
import java.util.UUID;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.RandomUtils;

public class RandomAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomAnnotationProcessor.class);

    private RandomAnnotationProcessor() {
    }

    public static void inject(Object object, Field field) throws Throwable {
        LOGGER.trace("inject class [%s] field [%s] field type [%s]", object.getClass().getName(), field.getName(), field.getType().getName());
        field.setAccessible(true);
        if (field.isAnnotationPresent(TestEngine.Random.Boolean.class)) {
            RandomAnnotationProcessor.setBoolean(object, field);
            return;
        }
        if (field.isAnnotationPresent(TestEngine.Random.Integer.class)) {
            TestEngine.Random.Integer annotation = field.getAnnotation(TestEngine.Random.Integer.class);
            RandomAnnotationProcessor.setInteger(object, field, annotation.minimum(), annotation.maximum());
            return;
        }
        if (field.isAnnotationPresent(TestEngine.Random.Long.class)) {
            TestEngine.Random.Long annotation = field.getAnnotation(TestEngine.Random.Long.class);
            RandomAnnotationProcessor.setLong(object, field, annotation.minimum(), annotation.maximum());
            return;
        }
        if (field.isAnnotationPresent(TestEngine.Random.Float.class)) {
            TestEngine.Random.Float annotation = field.getAnnotation(TestEngine.Random.Float.class);
            RandomAnnotationProcessor.setFloat(object, field, annotation.minimum(), annotation.maximum());
            return;
        }
        if (field.isAnnotationPresent(TestEngine.Random.Double.class)) {
            TestEngine.Random.Double annotation = field.getAnnotation(TestEngine.Random.Double.class);
            RandomAnnotationProcessor.setDouble(object, field, annotation.minimum(), annotation.maximum());
            return;
        }
        if (field.isAnnotationPresent(TestEngine.Random.BigInteger.class)) {
            TestEngine.Random.BigInteger annotation = field.getAnnotation(TestEngine.Random.BigInteger.class);
            RandomAnnotationProcessor.setBigInteger(object, field, annotation.minimum(), annotation.maximum());
            return;
        }
        if (field.isAnnotationPresent(TestEngine.Random.BigDecimal.class)) {
            TestEngine.Random.BigDecimal annotation = field.getAnnotation(TestEngine.Random.BigDecimal.class);
            RandomAnnotationProcessor.setBigDecimal(object, field, annotation.minimum(), annotation.maximum());
        }
        if (field.isAnnotationPresent(TestEngine.Random.UUID.class)) {
            LOGGER.trace("injecting UUID class [%s] field [%s]", object.getClass().getName(), field.getName());
            if (field.getType().equals(String.class)) {
                field.set(object, UUID.randomUUID().toString());
            } else {
                field.set(object, UUID.randomUUID());
            }
        }
    }

    private static void setBoolean(Object object, Field field) throws Throwable {
        LOGGER.trace("injecting random boolean class [%s] field [%s]", object.getClass().getName(), field.getName());
        field.set(object, RandomUtils.nextBoolean());
    }

    private static void setInteger(Object object, Field field, int minimum, int maximum) throws Throwable {
        LOGGER.trace("injecting random integer class [%s] field [%s] minimum [%s] maximum [%s]", object.getClass().getName(), field.getName(), minimum, maximum);
        field.setAccessible(true);
        field.set(object, RandomUtils.nextInteger(minimum, maximum));
    }

    private static void setLong(Object object, Field field, long minimum, long maximum) throws Throwable {
        LOGGER.trace("injecting random long class [%s] field [%s] minimum [%s] maximum [%s]", object.getClass().getName(), field.getName(), minimum, maximum);
        field.set(object, RandomUtils.nextLong(minimum, maximum));
    }

    private static void setFloat(Object object, Field field, float minimum, float maximum) throws Throwable {
        LOGGER.trace("injecting random float class [%s] field [%s] minimum [%s] maximum [%s]", object.getClass().getName(), field.getName(), Float.valueOf(minimum), Float.valueOf(maximum));
        field.set(object, Float.valueOf(RandomUtils.nextFloat(minimum, maximum)));
    }

    private static void setDouble(Object object, Field field, double minimum, double maximum) throws Throwable {
        LOGGER.trace("injecting random double class [%s] field [%s] minimum [%s] maximum [%s]", object.getClass().getName(), field.getName(), minimum, maximum);
        field.set(object, RandomUtils.nextDouble(minimum, maximum));
    }

    private static void setBigInteger(Object object, Field field, String minimum, String maximum) throws Throwable {
        LOGGER.trace("injecting random BigInteger class [%s] field [%s] minimum [%s] maximum [%s]", object.getClass().getName(), field.getName(), minimum, maximum);
        field.set(object, RandomUtils.nextBigInteger(minimum, maximum));
    }

    private static void setBigDecimal(Object object, Field field, String minimum, String maximum) throws Throwable {
        LOGGER.trace("injecting random BigDecimal class [%s] field [%s] minimum [%s] maximum [%s]", object.getClass().getName(), field.getName(), minimum, maximum);
        field.set(object, RandomUtils.nextBigDecimal(minimum, maximum));
    }
}

