/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class ReflectionUtils {
    public static final Class<?>[] NO_CLASS_ARGS = null;
    public static final Object[] NO_OBJECT_ARGS = null;

    private ReflectionUtils() {
    }

    public static Object newInstance(Class<?> clazz) throws Throwable {
        Constructor<?> constructor = clazz.getDeclaredConstructor(NO_CLASS_ARGS);
        return constructor.newInstance(NO_OBJECT_ARGS);
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    public static boolean isProtected(Method method) {
        return Modifier.isProtected(method.getModifiers());
    }

    public static boolean hasParameterCount(Method method, int parameterCount) {
        return method.getParameterCount() == parameterCount;
    }

    public static boolean acceptsArguments(Method method, Class<?> ... parameterTypes) {
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        if (parameterTypes == null || methodParameterTypes.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].isAssignableFrom(methodParameterTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasReturnType(Method method, Class<?> clazz) {
        if (clazz == Void.class) {
            return method.getReturnType().getName().equals("void");
        }
        return clazz.isAssignableFrom(method.getReturnType());
    }
}

