/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.util;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.internal.test.util.ReflectionUtils;
import org.antublue.test.engine.internal.test.util.ThrowableContext;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.util.ClassUtils;

public class TestUtils {
    private static final TestUtils SINGLETON = new TestUtils();
    private static final DefaultMethodOrderTopDownComparator DEFAULT_METHOD_ORDER_TOP_DOWN_COMPARATOR = new DefaultMethodOrderTopDownComparator();
    private static final DefaultMethodOrderBottomUpComparator DEFAULT_METHOD_ORDER_BOTTOM_UP_COMPARATOR = new DefaultMethodOrderBottomUpComparator();
    private static final TestEngineOrderAnnotationMethodComparator TEST_ENGINE_ORDER_ANNOTATION_COMPARATOR = new TestEngineOrderAnnotationMethodComparator();
    private static final MethodNameComparator METHOD_NAME_COMPARATOR = new MethodNameComparator();

    private TestUtils() {
    }

    public static TestUtils singleton() {
        return SINGLETON;
    }

    public static void invoke(Method method, Object testInstance, Object testArgument, ThrowableContext throwableContext) {
        try {
            method.setAccessible(true);
            if (ReflectionUtils.acceptsArguments(method, Argument.class)) {
                method.invoke(testInstance, testArgument);
            } else {
                method.invoke(testInstance, (Object[])null);
            }
        }
        catch (Throwable t) {
            throwableContext.add(testInstance.getClass(), t);
        }
    }

    public static String getDisplayName(Class<?> testClass) {
        String name;
        String displayName = testClass.getName();
        TestEngine.DisplayName annotation = testClass.getAnnotation(TestEngine.DisplayName.class);
        if (annotation != null && (name = annotation.name()) != null && !name.trim().isEmpty()) {
            displayName = name.trim();
        }
        return displayName;
    }

    public static String getDisplayName(Method testMethod) {
        String name;
        String displayName = testMethod.getName();
        TestEngine.DisplayName annotation = testMethod.getAnnotation(TestEngine.DisplayName.class);
        if (annotation != null && (name = annotation.name()) != null && !name.trim().isEmpty()) {
            displayName = name.trim();
        }
        return displayName;
    }

    public static String getTag(AnnotatedElement annotatedElement) {
        String tag;
        String tagValue = null;
        TestEngine.Tag annotation = annotatedElement.getAnnotation(TestEngine.Tag.class);
        if (annotation != null && (tag = annotation.tag()) != null && !tag.trim().isEmpty()) {
            tagValue = tag.trim();
        }
        return tagValue;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Method> orderTestMethods(List<Method> testMethods, HierarchyTraversalMode hierarchyTraversalMode) {
        LinkedHashMap<Class, List> methodMap = new LinkedHashMap<Class, List>();
        for (Method method : testMethods) {
            void var5_7;
            Class<?> clazz = method.getDeclaringClass().getComponentType();
            if (clazz == null) {
                Class<?> clazz2 = method.getDeclaringClass();
            }
            List methods = methodMap.computeIfAbsent((Class)var5_7, k -> new ArrayList());
            methods.add(method);
        }
        Comparator<Method> methodComparator = DEFAULT_METHOD_ORDER_TOP_DOWN_COMPARATOR;
        if (hierarchyTraversalMode == HierarchyTraversalMode.BOTTOM_UP) {
            methodComparator = DEFAULT_METHOD_ORDER_BOTTOM_UP_COMPARATOR;
        }
        for (Map.Entry entry : methodMap.entrySet()) {
            ((List)entry.getValue()).sort(methodComparator);
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Class key : methodMap.keySet()) {
            List methods = (List)methodMap.get(key);
            arrayList.addAll(methods);
        }
        return arrayList;
    }

    private static class MethodNameComparator
    implements Comparator<Method> {
        private MethodNameComparator() {
        }

        @Override
        public int compare(Method method1, Method method2) {
            int comparison = method1.getName().compareTo(method2.getName());
            if (comparison == 0) {
                comparison = ClassUtils.nullSafeToString((Class[])method1.getParameterTypes()).compareTo(ClassUtils.nullSafeToString((Class[])method2.getParameterTypes()));
            }
            return comparison;
        }
    }

    private static class TestEngineOrderAnnotationMethodComparator
    implements Comparator<Method> {
        private static final int DEFAULT_ORDER = Integer.MAX_VALUE;

        private TestEngineOrderAnnotationMethodComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            int o1Order = Integer.MAX_VALUE;
            TestEngine.Order o1Annotation = o1.getAnnotation(TestEngine.Order.class);
            if (o1Annotation != null) {
                o1Order = o1Annotation.order();
            }
            int o2Order = Integer.MAX_VALUE;
            TestEngine.Order o2Annotation = o2.getAnnotation(TestEngine.Order.class);
            if (o2Annotation != null) {
                o2Order = o2Annotation.order();
            }
            return Integer.compare(o1Order, o2Order);
        }
    }

    private static class DefaultMethodOrderBottomUpComparator
    implements Comparator<Method> {
        private DefaultMethodOrderBottomUpComparator() {
        }

        @Override
        public int compare(Method method1, Method method2) {
            int comparison = TEST_ENGINE_ORDER_ANNOTATION_COMPARATOR.compare(method1, method2);
            if (comparison == 0) {
                comparison = -METHOD_NAME_COMPARATOR.compare(method1, method2);
            }
            return comparison;
        }
    }

    private static class DefaultMethodOrderTopDownComparator
    implements Comparator<Method> {
        private DefaultMethodOrderTopDownComparator() {
        }

        @Override
        public int compare(Method method1, Method method2) {
            int comparison = TEST_ENGINE_ORDER_ANNOTATION_COMPARATOR.compare(method1, method2);
            if (comparison == 0) {
                comparison = METHOD_NAME_COMPARATOR.compare(method1, method2);
            }
            return comparison;
        }
    }
}

