/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.test.util;

import java.util.ArrayList;
import java.util.List;
import org.antublue.test.engine.internal.util.StandardStreams;
import org.antublue.test.engine.internal.util.ThrowableUtils;

public class ThrowableContext {
    private static final boolean PRINT_STACKTRACE = "true".equals(System.getProperty("antublue.test.engine.maven.plugin"));
    private final List<Throwable> throwables = new ArrayList<Throwable>();

    public void add(Class<?> clazz, Throwable throwable) {
        Throwable prunedThrowable = ThrowableUtils.prune(clazz, throwable);
        if (PRINT_STACKTRACE) {
            prunedThrowable.printStackTrace();
            StandardStreams.flush();
        }
        this.throwables.add(prunedThrowable);
    }

    public boolean isEmpty() {
        return this.throwables.isEmpty();
    }

    public Throwable getFirst() {
        return this.throwables.get(0);
    }

    public List<Throwable> getThrowables() {
        return this.throwables;
    }

    public void throwFirst() throws Throwable {
        if (!this.throwables.isEmpty()) {
            throw this.throwables.get(0);
        }
    }

    public void clear() {
        this.throwables.clear();
    }
}

