/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtils {
    private RandomUtils() {
    }

    public static boolean nextBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static int nextInteger(int minimum, int maximum) {
        if (minimum == maximum) {
            return minimum;
        }
        int realMinimum = Math.min(minimum, maximum);
        int realMaximum = Math.max(minimum, maximum);
        int random = ThreadLocalRandom.current().nextInt(realMinimum, realMaximum);
        if (ThreadLocalRandom.current().nextBoolean()) {
            ++random;
        }
        return random;
    }

    public static long nextLong(long minimum, long maximum) {
        if (minimum == maximum) {
            return minimum;
        }
        long realMinimum = Math.min(minimum, maximum);
        long realMaximum = Math.max(minimum, maximum);
        long random = ThreadLocalRandom.current().nextLong(realMinimum, realMaximum);
        if (ThreadLocalRandom.current().nextBoolean()) {
            ++random;
        }
        return random;
    }

    public static float nextFloat(float minimum, float maximum) {
        if (minimum == maximum) {
            return minimum;
        }
        return RandomUtils.nextBigDecimal(BigDecimal.valueOf(minimum), BigDecimal.valueOf(maximum)).floatValue();
    }

    public static double nextDouble(double minimum, double maximum) {
        if (minimum == maximum) {
            return minimum;
        }
        return RandomUtils.nextBigDecimal(BigDecimal.valueOf(minimum), BigDecimal.valueOf(maximum)).doubleValue();
    }

    public static BigInteger nextBigInteger(String minimum, String maximum) {
        BigDecimal maximumBigDecimal;
        BigDecimal minimumBigDecimal;
        if (minimum.contains(".")) {
            throw new NumberFormatException(String.format("BigInteger minimum [%s] is invalid ", minimum));
        }
        if (maximum.contains(".")) {
            throw new NumberFormatException(String.format("BigInteger maximum [%s] is invalid", maximum));
        }
        try {
            minimumBigDecimal = new BigDecimal(minimum);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("BigDecimal minimum [%s] is invalid", minimum));
        }
        try {
            maximumBigDecimal = new BigDecimal(maximum);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("BigDecimal maximum [%s] is invalid", maximum));
        }
        if (minimumBigDecimal.equals(maximumBigDecimal)) {
            return new BigInteger(minimum);
        }
        if (maximumBigDecimal.subtract(minimumBigDecimal).abs().equals(BigDecimal.ONE)) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                return new BigInteger(minimum);
            }
            return new BigInteger(maximum);
        }
        if (minimumBigDecimal.compareTo(maximumBigDecimal) > 0) {
            BigDecimal temp = maximumBigDecimal;
            maximumBigDecimal = minimumBigDecimal;
            minimumBigDecimal = temp;
        }
        maximumBigDecimal = maximumBigDecimal.add(BigDecimal.ONE);
        int digitCount = Math.max(minimumBigDecimal.precision(), maximumBigDecimal.precision());
        int bitCount = (int)((double)digitCount / Math.log10(2.0));
        BigDecimal random = RandomUtils.nextBigDecimal(minimumBigDecimal, maximumBigDecimal);
        BigInteger bigInteger = random.round(new MathContext(bitCount, RoundingMode.DOWN)).toBigInteger();
        if (ThreadLocalRandom.current().nextBoolean()) {
            bigInteger = bigInteger.add(BigInteger.ONE);
        }
        return bigInteger;
    }

    public static BigDecimal nextBigDecimal(String minimum, String maximum) {
        BigDecimal maximummBigDecimal;
        BigDecimal minimumBigDecimal;
        try {
            minimumBigDecimal = new BigDecimal(minimum);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("BigDecimal minimum [%s] is invalid", minimum));
        }
        try {
            maximummBigDecimal = new BigDecimal(maximum);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("BigDecimal maximum [%s] is invalid", maximum));
        }
        return RandomUtils.nextBigDecimal(minimumBigDecimal, maximummBigDecimal);
    }

    private static BigDecimal nextBigDecimal(BigDecimal minimum, BigDecimal maximum) {
        if (minimum.equals(maximum)) {
            return minimum;
        }
        BigDecimal realMinimum = minimum;
        BigDecimal realMaximum = maximum;
        if (realMinimum.compareTo(realMaximum) < 0) {
            BigDecimal temp = realMinimum;
            realMinimum = realMaximum;
            realMaximum = temp;
        }
        int digitCount = Math.max(realMinimum.precision(), realMaximum.precision()) + 10;
        int bitCount = (int)((double)digitCount / Math.log10(2.0));
        BigDecimal alpha = new BigDecimal(new BigInteger(bitCount, ThreadLocalRandom.current())).movePointLeft(digitCount);
        return minimum.add(maximum.subtract(minimum).multiply(alpha, new MathContext(digitCount)));
    }
}

