/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class Configuration {
    private static Configuration INSTANCE;
    public static final String ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE = "ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_ENVIRONMENT_VARIABLE = "ANTUBLUE_TEST_ENGINE_PROPERTIES";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_SYSTEM_PROPERTY = "antublue.test.engine.properties";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME_1 = "antublue-test-engine.properties";
    private static final String ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME_2 = ".antublue-test-engine.properties";
    private static final boolean TRACE;
    private String propertiesFilename;
    private final Properties properties;
    private Set<String> keySet;

    public Configuration() {
        File propertiesFile;
        this.trace("Configuration()", new Object[0]);
        this.properties = new Properties();
        String value = System.getenv(ANTUBLUE_TEST_ENGINE_PROPERTIES_ENVIRONMENT_VARIABLE);
        if (value != null && !value.trim().isEmpty()) {
            this.propertiesFilename = value.trim();
        }
        if (this.propertiesFilename == null && (value = System.getProperty(ANTUBLUE_TEST_ENGINE_PROPERTIES_SYSTEM_PROPERTY)) != null && !value.trim().isEmpty()) {
            this.propertiesFilename = value.trim();
        }
        if ((propertiesFile = this.find(Paths.get(".", new String[0]), ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME_1)) == null) {
            propertiesFile = this.find(Paths.get(".", new String[0]), ANTUBLUE_TEST_ENGINE_PROPERTIES_FILENAME_2);
        }
        if (propertiesFile != null) {
            this.propertiesFilename = propertiesFile.getAbsolutePath();
            this.trace("loading properties [%s]", this.propertiesFilename);
            try (FileReader reader = new FileReader(propertiesFile);){
                this.properties.load(reader);
                TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
                for (Object key : this.properties.keySet()) {
                    map.put((String)key, true);
                }
                this.keySet = map.keySet();
                this.trace("properties loaded [%s]", this.propertiesFilename);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.keySet == null) {
            this.keySet = new LinkedHashSet<String>();
        }
    }

    public static synchronized Configuration getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Configuration();
        }
        return INSTANCE;
    }

    public String getPropertiesFilename() {
        return this.propertiesFilename;
    }

    public Optional<String> get(String key) {
        String value = this.properties.getProperty(key);
        this.trace("get key [%s] value [%s]", key, value);
        return Optional.ofNullable(value);
    }

    public Optional<Boolean> getBoolean(String key) {
        Optional<String> value = this.get(key);
        if (value.isPresent()) {
            String string = value.get();
            this.trace("getBoolean key [%s] value [%s]", key, string);
            return Optional.of(Boolean.parseBoolean(string));
        }
        this.trace("getBoolean key [%s] value [%s]", key, null);
        return Optional.empty();
    }

    public int size() {
        return this.properties.size();
    }

    public Set<String> keySet() {
        return this.keySet;
    }

    private void trace(String format, Object ... objects) {
        if (TRACE) {
            System.out.println("[TRACE] " + Configuration.class + " " + String.format(format, objects));
            System.out.flush();
        }
    }

    private File find(Path path, String filename) {
        Path currentPath = path.toAbsolutePath().normalize();
        while (true) {
            this.trace("searching path [%s]", currentPath);
            File propertiesFile = new File(currentPath.toAbsolutePath() + File.separator + filename);
            if (propertiesFile.exists() && propertiesFile.isFile() && propertiesFile.canRead()) {
                return propertiesFile;
            }
            if ((currentPath = currentPath.getParent()) == null) break;
            currentPath = currentPath.toAbsolutePath().normalize();
        }
        return null;
    }

    static {
        TRACE = "true".equals(System.getenv(ANTUBLUE_TEST_ENGINE_CONFIGURATION_TRACE));
    }
}

