/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.antublue.test.engine.Configuration;
import org.antublue.test.engine.api.Argument;
import org.antublue.test.engine.api.Extension;
import org.antublue.test.engine.api.TestEngine;
import org.antublue.test.engine.exception.TestClassDefinitionException;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.antublue.test.engine.internal.util.ReflectionUtils;
import org.antublue.test.engine.internal.util.ThrowableContext;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;

public class ExtensionManager {
    private static ExtensionManager INSTANCE;
    private static final Logger LOGGER;
    private static final Configuration CONFIGURATION;
    private static final List<Extension> EMPTY_EXTENSION_LIST;
    private final List<Extension> globalExtensions = new ArrayList<Extension>();
    private final List<Extension> globalExtensionsReversed = new ArrayList<Extension>();
    private final Map<Class<?>, List<Extension>> testExtensionsMap = new HashMap();
    private final Map<Class<?>, List<Extension>> testExtensionsReversedMap = new HashMap();
    private boolean initialized;
    public static final Predicate<Method> EXTENSION_SUPPLIER_METHOD;

    private ExtensionManager() {
    }

    public static synchronized ExtensionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExtensionManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws Throwable {
        LOGGER.trace("initialize()");
        ExtensionManager extensionManager = this;
        synchronized (extensionManager) {
            if (this.initialized) {
                return;
            }
            LinkedHashMap<String, Extension> extensionMap = new LinkedHashMap<String, Extension>();
            Optional<String> optional = CONFIGURATION.get("antublue.test.engine.extensions");
            if (optional.isPresent() && !optional.get().trim().isEmpty()) {
                String[] classNames;
                for (String className : classNames = optional.get().split("\\s+")) {
                    Class<?> clazz;
                    Object object;
                    LOGGER.trace("loading extension [%s]", (Object)className);
                    if (extensionMap.containsKey(className) || !((object = ReflectionUtils.newInstance(clazz = Thread.currentThread().getContextClassLoader().loadClass(className))) instanceof Extension)) continue;
                    extensionMap.put(className, (Extension)object);
                }
                this.globalExtensions.addAll(extensionMap.values());
                this.globalExtensionsReversed.addAll(this.globalExtensions);
                Collections.reverse(this.globalExtensionsReversed);
            }
            this.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(Class<?> testClass) {
        LOGGER.trace("initialize() test class [%s]", (Object)testClass.getName());
        try {
            this.initialize();
            ExtensionManager extensionManager = this;
            synchronized (extensionManager) {
                List<Extension> testExtensions = this.testExtensionsMap.get(testClass);
                if (testExtensions == null) {
                    testExtensions = new ArrayList<Extension>(this.globalExtensions);
                    testExtensions.addAll(this.buildTestExtensionList(testClass));
                    ArrayList<Extension> testExtensionReversed = new ArrayList<Extension>(testExtensions);
                    Collections.reverse(testExtensionReversed);
                    this.testExtensionsMap.put(testClass, testExtensions);
                    this.testExtensionsReversedMap.put(testClass, testExtensionReversed);
                }
            }
        }
        catch (Throwable t) {
            throw new TestEngineException(String.format("Exception initializing extensions for test class [%s]", testClass.getName()), t);
        }
    }

    public void postTestArgumentDiscoveryCallback(Class<?> testClass, List<Argument> testArguments, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensions(testClass)) {
            try {
                testExtension.postTestArgumentDiscoveryCallback(testClass, testArguments);
            }
            catch (Throwable t) {
                throwableContext.add(testClass, t);
            }
        }
    }

    public void postTestMethodDiscoveryCallback(Class<?> testClass, List<Method> testMethods, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensions(testClass)) {
            try {
                testExtension.postTestMethodDiscoveryCallback(testClass, testMethods);
            }
            catch (Throwable t) {
                throwableContext.add(testClass, t);
            }
        }
    }

    public void preInstantiateCallback(Class<?> testClass, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensions(testClass)) {
            try {
                testExtension.preInstantiateCallback(testClass);
            }
            catch (Throwable t) {
                throwableContext.add(testClass, t);
            }
        }
    }

    public void postInstantiateCallback(Object testInstance, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensionsReversed(testInstance.getClass())) {
            try {
                testExtension.postInstantiateCallback(testInstance);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void prePrepareMethodsCallback(Object testInstance, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensions(testInstance.getClass())) {
            try {
                testExtension.prePrepareMethodsCallback(testInstance);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void postPrepareMethodsCallback(Object testInstance, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensionsReversed(testInstance.getClass())) {
            try {
                testExtension.postPrepareMethodsCallback(testInstance);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void preBeforeAllMethodsCallback(Object testInstance, Argument testArgument, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensions(testInstance.getClass())) {
            try {
                testExtension.preBeforeAllMethodsCallback(testInstance, testArgument);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void postBeforeAllMethodsCallback(Object testInstance, Argument testArgument, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensionsReversed(testInstance.getClass())) {
            try {
                testExtension.postBeforeAllMethodsCallback(testInstance, testArgument);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void preBeforeEachMethodsCallback(Object testInstance, Argument testArgument, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensions(testInstance.getClass())) {
            try {
                testExtension.preBeforeEachMethodsCallback(testInstance, testArgument);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void postBeforeEachMethodsCallback(Object testInstance, Argument testArgument, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensionsReversed(testInstance.getClass())) {
            try {
                testExtension.postBeforeEachMethodsCallback(testInstance, testArgument);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void preTestMethodsCallback(Method testMethod, Object testInstance, Argument testArgument, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensions(testInstance.getClass())) {
            try {
                testExtension.preTestMethodsCallback(testMethod, testInstance, testArgument);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void postTestMethodsCallback(Method testMethod, Object testInstance, Argument testArgument, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensionsReversed(testInstance.getClass())) {
            try {
                testExtension.postTestMethodsCallback(testMethod, testInstance, testArgument);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void preAfterEachMethodsCallback(Object testInstance, Argument testArgument, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensions(testInstance.getClass())) {
            try {
                testExtension.preAfterEachMethodsCallback(testInstance, testArgument);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void postAfterEachMethodsCallback(Object testInstance, Argument testArgument, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensionsReversed(testInstance.getClass())) {
            try {
                testExtension.postAfterEachMethodsCallback(testInstance, testArgument);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void preAfterAllMethodsCallback(Object testInstance, Argument testArgument, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensions(testInstance.getClass())) {
            try {
                testExtension.preAfterAllMethodsCallback(testInstance, testArgument);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void postAfterAllMethodsCallback(Object testInstance, Argument testArgument, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensionsReversed(testInstance.getClass())) {
            try {
                testExtension.postAfterAllMethodsCallback(testInstance, testArgument);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void preConcludeMethodsCallback(Object testInstance, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensions(testInstance.getClass())) {
            try {
                testExtension.preConcludeMethodsCallback(testInstance);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void postConcludeMethodsCallback(Object testInstance, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensionsReversed(testInstance.getClass())) {
            try {
                testExtension.postConcludeMethodsCallback(testInstance);
            }
            catch (Throwable t) {
                throwableContext.add(testInstance.getClass(), t);
            }
        }
    }

    public void preDestroyCallback(Class<?> testClass, Optional<Object> optionalTestInstance, ThrowableContext throwableContext) {
        for (Extension testExtension : this.getTestExtensionsReversed(testClass)) {
            try {
                testExtension.preDestroyCallback(testClass, optionalTestInstance);
            }
            catch (Throwable t) {
                throwableContext.add(testClass, t);
            }
        }
    }

    private List<Extension> buildTestExtensionList(Class<?> testClass) throws Throwable {
        LOGGER.trace("buildTestExtensionList() testClass [%s]", (Object)testClass.getName());
        ArrayList<Extension> testExtensions = new ArrayList<Extension>();
        List extensionSupplierMethods = ReflectionSupport.findMethods(testClass, EXTENSION_SUPPLIER_METHOD, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        for (Method method : extensionSupplierMethods) {
            Object object = method.invoke(null, (Object[])null);
            if (object instanceof Stream) {
                Stream stream = (Stream)object;
                stream.forEach(testExtensions::add);
                continue;
            }
            if (object instanceof Iterable) {
                ((Iterable)object).forEach(testExtensions::add);
                continue;
            }
            throw new TestClassDefinitionException(String.format("Exception getting extensions for test class [%s]", testClass.getName()));
        }
        return testExtensions;
    }

    private List<Extension> getTestExtensions(Class<?> testClass) {
        this.initialize(testClass);
        return this.testExtensionsMap.getOrDefault(testClass, EMPTY_EXTENSION_LIST);
    }

    private List<Extension> getTestExtensionsReversed(Class<?> testClass) {
        this.initialize(testClass);
        return this.testExtensionsReversedMap.getOrDefault(testClass, EMPTY_EXTENSION_LIST);
    }

    static {
        LOGGER = LoggerFactory.getLogger(ExtensionManager.class);
        CONFIGURATION = Configuration.getInstance();
        EMPTY_EXTENSION_LIST = new ArrayList<Extension>();
        EXTENSION_SUPPLIER_METHOD = method -> !(!method.isAnnotationPresent(TestEngine.ExtensionSupplier.class) || method.isAnnotationPresent(TestEngine.Disabled.class) || !ReflectionUtils.isStatic(method) || !ReflectionUtils.isPublic(method) && !ReflectionUtils.isProtected(method) || !ReflectionUtils.hasParameterCount(method, 0) || !ReflectionUtils.hasReturnType(method, Stream.class) && !ReflectionUtils.hasReturnType(method, Iterable.class));
    }
}

