/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antublue.test.engine.Configuration;
import org.antublue.test.engine.Information;
import org.antublue.test.engine.exception.TestClassDefinitionException;
import org.antublue.test.engine.exception.TestEngineException;
import org.antublue.test.engine.internal.ConfigurationParameters;
import org.antublue.test.engine.internal.Executor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.EngineDescriptorFactory;
import org.antublue.test.engine.internal.descriptor.MethodTestDescriptor;
import org.antublue.test.engine.internal.logger.Logger;
import org.antublue.test.engine.internal.logger.LoggerFactory;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;

public class TestEngine
implements org.junit.platform.engine.TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEngine.class);
    private static final Configuration CONFIGURATION = Configuration.getInstance();
    public static final String ENGINE_ID = "antublue-test-engine";
    public static final String GROUP_ID = "org.antublue";
    public static final String ARTIFACT_ID = "test-engine";
    public static final String VERSION = Information.getInstance().getVersion();

    public String getId() {
        return ENGINE_ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of(GROUP_ID);
    }

    public Optional<String> getArtifactId() {
        return Optional.of(ARTIFACT_ID);
    }

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        LOGGER.trace("discover()");
        try {
            EngineDescriptor engineDescriptor = EngineDescriptorFactory.getInstance().createEngineDescriptor(uniqueId, this.getId(), engineDiscoveryRequest);
            this.filterTestClassesByClassName(engineDescriptor);
            this.filterTestClassesByTag(engineDescriptor);
            this.filterTestMethodsByMethodName(engineDescriptor);
            this.filterTestMethodsByTag(engineDescriptor);
            this.prune((TestDescriptor)engineDescriptor);
            this.shuffleOrSortTestDescriptors(engineDescriptor);
            return engineDescriptor;
        }
        catch (TestClassDefinitionException | TestEngineException t) {
            if ("true".equals(System.getProperty("antublue.test.engine.maven.plugin"))) {
                throw t;
            }
            System.err.println(t.getMessage());
            System.exit(1);
        }
        catch (Throwable t) {
            throw new TestEngineException("General exception", t);
        }
        return null;
    }

    private void filterTestClassesByClassName(EngineDescriptor engineDescriptor) {
        ClassTestDescriptor classTestDescriptor;
        LinkedHashSet children;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestClassesByClassName()");
        Optional<String> optional = CONFIGURATION.get("antublue.test.engine.test.class.include.regex");
        if (optional.isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof ClassTestDescriptor)) continue;
                classTestDescriptor = (ClassTestDescriptor)testDescriptor;
                matcher.reset(classTestDescriptor.getTestClass().getName());
                if (matcher.find()) continue;
                classTestDescriptor.removeFromHierarchy();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.class.exclude.regex")).isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof ClassTestDescriptor)) continue;
                classTestDescriptor = (ClassTestDescriptor)testDescriptor;
                matcher.reset(classTestDescriptor.getTestClass().getName());
                if (!matcher.find()) continue;
                classTestDescriptor.removeFromHierarchy();
            }
        }
    }

    private void filterTestClassesByTag(EngineDescriptor engineDescriptor) {
        String tag;
        ClassTestDescriptor classTestDescriptor;
        LinkedHashSet children;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestClassesByTag()");
        Optional<String> optional = CONFIGURATION.get("antublue.test.engine.test.class.tag.include.regex");
        if (optional.isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof ClassTestDescriptor)) continue;
                classTestDescriptor = (ClassTestDescriptor)testDescriptor;
                tag = classTestDescriptor.getTag();
                if (tag != null) {
                    matcher.reset(tag);
                    if (matcher.find()) continue;
                    classTestDescriptor.removeFromHierarchy();
                    continue;
                }
                classTestDescriptor.removeFromHierarchy();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.class.tag.exclude.regex")).isPresent()) {
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof ClassTestDescriptor) || (tag = (classTestDescriptor = (ClassTestDescriptor)testDescriptor).getTag()) == null) continue;
                matcher.reset(tag);
                if (!matcher.find()) continue;
                classTestDescriptor.removeFromHierarchy();
            }
        }
    }

    private void filterTestMethodsByMethodName(EngineDescriptor engineDescriptor) {
        MethodTestDescriptor methodTestDescriptor;
        LinkedHashSet children;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestMethodsByMethodName()");
        Optional<String> optional = CONFIGURATION.get("antublue.test.engine.test.method.include.regex");
        if (optional.isPresent()) {
            LOGGER.trace("[%s] = [%s]", "antublue.test.engine.test.method.include.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof MethodTestDescriptor)) continue;
                methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                matcher.reset(methodTestDescriptor.getTestMethod().getName());
                if (matcher.find()) continue;
                methodTestDescriptor.removeFromHierarchy();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.method.exclude.regex")).isPresent()) {
            LOGGER.trace("[%s] = [%s]", "antublue.test.engine.test.method.exclude.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof MethodTestDescriptor)) continue;
                methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                matcher.reset(methodTestDescriptor.getTestMethod().getName());
                if (!matcher.find()) continue;
                methodTestDescriptor.removeFromHierarchy();
            }
        }
    }

    private void filterTestMethodsByTag(EngineDescriptor engineDescriptor) {
        String tag;
        MethodTestDescriptor methodTestDescriptor;
        LinkedHashSet children;
        Matcher matcher;
        Pattern pattern;
        LOGGER.trace("filterTestMethodsByTag()");
        Optional<String> optional = CONFIGURATION.get("antublue.test.engine.test.method.tag.include.regex");
        if (optional.isPresent()) {
            LOGGER.trace("[%s] = [%s]", "antublue.test.engine.test.method.tag.include.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof MethodTestDescriptor)) continue;
                methodTestDescriptor = (MethodTestDescriptor)testDescriptor;
                tag = methodTestDescriptor.getTag();
                if (tag != null) {
                    matcher.reset(tag);
                    if (matcher.find()) continue;
                    methodTestDescriptor.removeFromHierarchy();
                    continue;
                }
                methodTestDescriptor.removeFromHierarchy();
            }
        }
        if ((optional = CONFIGURATION.get("antublue.test.engine.test.method.tag.exclude.regex")).isPresent()) {
            LOGGER.trace("[%s] = [%s]", "antublue.test.engine.test.method.tag.exclude.regex", optional.get());
            pattern = Pattern.compile(optional.get());
            matcher = pattern.matcher("");
            children = new LinkedHashSet(engineDescriptor.getDescendants());
            for (TestDescriptor testDescriptor : children) {
                if (!(testDescriptor instanceof MethodTestDescriptor) || (tag = (methodTestDescriptor = (MethodTestDescriptor)testDescriptor).getTag()) == null) continue;
                matcher.reset(tag);
                if (!matcher.find()) continue;
                methodTestDescriptor.removeFromHierarchy();
            }
        }
    }

    private void prune(TestDescriptor testDescriptor) {
        LinkedHashSet children = new LinkedHashSet(testDescriptor.getChildren());
        for (TestDescriptor child : children) {
            this.prune(child);
        }
        if (testDescriptor.isRoot()) {
            return;
        }
        if (testDescriptor.isContainer() && testDescriptor.getChildren().isEmpty()) {
            testDescriptor.removeFromHierarchy();
        }
    }

    private void shuffleOrSortTestDescriptors(EngineDescriptor engineDescriptor) {
        ArrayList<TestDescriptor> testDescriptors = new ArrayList<TestDescriptor>(engineDescriptor.getChildren());
        testDescriptors.forEach(arg_0 -> ((EngineDescriptor)engineDescriptor).removeChild(arg_0));
        Optional<String> optionalShuffle = CONFIGURATION.get("antublue.test.engine.test.class.shuffle");
        if (optionalShuffle.isPresent() && "true".equals(optionalShuffle.get())) {
            Collections.shuffle(testDescriptors);
        } else {
            testDescriptors.sort(Comparator.comparing(TestDescriptor::getDisplayName));
        }
        testDescriptors.forEach(arg_0 -> ((EngineDescriptor)engineDescriptor).addChild(arg_0));
    }

    public void execute(ExecutionRequest executionRequest) {
        LOGGER.trace("execute()");
        EngineExecutionListener engineExecutionListener = executionRequest.getEngineExecutionListener();
        try {
            engineExecutionListener.executionStarted(executionRequest.getRootTestDescriptor());
            new Executor().execute(ExecutionRequest.create((TestDescriptor)executionRequest.getRootTestDescriptor(), (EngineExecutionListener)executionRequest.getEngineExecutionListener(), (org.junit.platform.engine.ConfigurationParameters)ConfigurationParameters.getInstance()));
        }
        finally {
            engineExecutionListener.executionFinished(executionRequest.getRootTestDescriptor(), TestExecutionResult.successful());
        }
    }
}

