/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.internal;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.antublue.test.engine.Configuration;

public class ConfigurationParameters
implements org.junit.platform.engine.ConfigurationParameters {
    private static ConfigurationParameters INSTANCE;
    private static final Configuration CONFIGURATION;

    private ConfigurationParameters() {
    }

    public static synchronized ConfigurationParameters getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigurationParameters();
        }
        return INSTANCE;
    }

    public Optional<String> get(String key) {
        return CONFIGURATION.get(key);
    }

    public Optional<Boolean> getBoolean(String key) {
        return CONFIGURATION.getBoolean(key);
    }

    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        Optional<String> value = CONFIGURATION.get(key);
        if (value.isPresent()) {
            return Optional.ofNullable(transformer.apply(value.get()));
        }
        return Optional.empty();
    }

    public int size() {
        return CONFIGURATION.size();
    }

    public Set<String> keySet() {
        return CONFIGURATION.keySet();
    }

    static {
        CONFIGURATION = Configuration.getInstance();
    }
}

